/***************************************************************************
                          setup.h  -  description
                             -------------------
    begin                : Fri Dec 21 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETUP_H
#define SETUP_H

#include <qstring.h>
#include <ksimpleconfig.h>

#include "setup_dialog.h"
#include "gphoto_interface.h"



class Setup : public Setup_Dialog  {

public: 
  Setup(QWidget *parent=0, const char *name=0, WFlags fl = WDestructiveClose);
  ~Setup();

private:

  void getCameraListings();
  void getPortListings();
  void loadCameraSettings();
  void saveCameraSettings();
  void loadGeneralSettings();
  void saveGeneralSettings();

  KSimpleConfig *config;
  
  QStringList supportedSerialPorts;
  QString my_cameraModel;
  QString my_cameraPort;

  Gphoto_Interface *gpInterface;


protected slots:

  void slot_ok();
  void slot_apply();
  void slot_cancel();
  void slot_autoDetect();
  void slot_setModel(QListViewItem *);
  void slot_setPort(int portType);
  void slot_setPortPathLabel(int portType);
  void slot_browse();
	
};

#endif
