#include "thumbnail_mt.h"


Thumbnail_MT::Thumbnail_MT() {

  mutex.lock();

  data = NULL;
  size = 0;

  mutex.unlock();

}

Thumbnail_MT::Thumbnail_MT(const unsigned char* _data, 
			   unsigned int _size) {

  mutex.lock();

  size = _size;
  data = new unsigned char[size];

  for (unsigned int i=0; i<size; i++)
    data[i] = _data[i];

  mutex.unlock();
}


Thumbnail_MT::~Thumbnail_MT() {

  mutex.lock();

  if (data) 
    delete [] data;
  data = NULL;
  size = 0;

  mutex.unlock();

}

Thumbnail_MT::Thumbnail_MT(const Thumbnail_MT& thumb) {

  mutex.lock();
  
  size = thumb.size;
  data = new unsigned char[size];

  for (unsigned int i=0; i<size; i++)
    data[i] = thumb.data[i];

  mutex.unlock();

}


Thumbnail_MT& Thumbnail_MT::operator=(const Thumbnail_MT& thumb) {

  mutex.lock();

  if (this != &thumb) {
    
    if (data) 
      delete [] data;

    size = thumb.size;
    data = new unsigned char[size];

    for (unsigned int i=0; i<size; i++)
      data[i] = thumb.data[i];

  }

  mutex.unlock();

  return *this;

}


void Thumbnail_MT::load(const unsigned char* _data, unsigned int _size) {

  mutex.lock();
  
  if (data) 
    delete [] data;
  data = NULL;

  size = _size;
  data = new unsigned char[size];
  
  for (unsigned int i=0; i<size; i++)
    data[i] = _data[i];

  mutex.unlock();

}


bool Thumbnail_MT::isNull() {

  mutex.lock();
  
  bool _isnull;
  
  if (size == 0) 
    _isnull = true;
  else
    _isnull = false;

  mutex.unlock();

  return _isnull;

}

void Thumbnail_MT::fillPixmap(QPixmap& pix) {
  
  mutex.lock();

  pix.loadFromData((const uchar*) data, (uint) size);

  mutex.unlock();

}
