#ifndef THUMBNAILSIZE_H
#define THUMBNAILSIZE_H

#include <qstring.h>
#include <qsize.h>


class ThumbnailSize {

public:

  enum Size { Small, Med, Large };

  ThumbnailSize(Size value=Large);
  ThumbnailSize(const QString& str);
  ThumbnailSize(const ThumbnailSize& thumbSize);


    bool operator==(const ThumbnailSize& thumbSize) const;
    void setSize(Size _size) {size = _size;}
    Size mySize() const { return size; }
    QSize rescaledSize(const QSize& origSize) const;
    double scaleFactor() const;

private:

  Size size;

};

#endif
