#ifndef CAMERAFILEITEM_H
#define CAMERAFILEITEM_H

#include <qobject.h>

class QPixmap;
class CameraFileItemInfo;

class CameraFileItem: public QObject {

    Q_OBJECT

public:

    CameraFileItem(const CameraFileItemInfo& _fileInfo);
    ~CameraFileItem();

    void setPixmap(const QPixmap& pixmap);
    QPixmap* pixmap() const;

    void setDownloaded(bool val);

    CameraFileItemInfo* fileInfo() const;

private:

    QPixmap* mThumbnail;
    CameraFileItemInfo* mFileInfo;

signals:

    void signal_thumbnailChanged();
    void signal_downloadStatusChanged();
    void signal_deleted();

};

#endif
