#include <qpainter.h>
#include <kiconloader.h>

#include "camerafileitem.h"
#include "camerafileiteminfo.h"
#include "camerafolderitem.h"

//=================================================================

static const char * camera_xpm[] = {
"32 32 110 2",
"  	c None",
". 	c #000000",
"+ 	c #777777",
"@ 	c #444444",
"# 	c #545454",
"$ 	c #565656",
"% 	c #585858",
"& 	c #5B5B5B",
"* 	c #5D5D5D",
"= 	c #606060",
"- 	c #626262",
"; 	c #646464",
"> 	c #676767",
", 	c #696969",
"' 	c #6B6B6B",
") 	c #6E6E6E",
"! 	c #707070",
"~ 	c #727272",
"{ 	c #757575",
"] 	c #7A7A7A",
"^ 	c #7C7C7C",
"/ 	c #7E7E7E",
"( 	c #818181",
"_ 	c #838383",
": 	c #858585",
"< 	c #5F5F5F",
"[ 	c #666666",
"} 	c #797979",
"| 	c #888888",
"1 	c #5A5A5A",
"2 	c #616161",
"3 	c #6D6D6D",
"4 	c #747474",
"5 	c #FFFFFF",
"6 	c #8A8A8A",
"7 	c #686868",
"8 	c #6F6F6F",
"9 	c #7B7B7B",
"0 	c #8C8C8C",
"a 	c #5C5C5C",
"b 	c #636363",
"c 	c #767676",
"d 	c #808080",
"e 	c #8E8E8E",
"f 	c #5E5E5E",
"g 	c #6A6A6A",
"h 	c #717171",
"i 	c #7D7D7D",
"j 	c #828282",
"k 	c #848484",
"l 	c #878787",
"m 	c #898989",
"n 	c #909090",
"o 	c #656565",
"p 	c #999999",
"q 	c #A1A1A1",
"r 	c #9C9C9C",
"s 	c #959595",
"t 	c #8B8B8B",
"u 	c #929292",
"v 	c #6C6C6C",
"w 	c #3F3F3F",
"x 	c #111111",
"y 	c #949494",
"z 	c #979797",
"A 	c #737373",
"B 	c #575757",
"C 	c #161616",
"D 	c #9E9E9E",
"E 	c #1B1B1B",
"F 	c #E1E1E1",
"G 	c #9B9B9B",
"H 	c #9D9D9D",
"I 	c #353535",
"J 	c #A0A0A0",
"K 	c #9F9F9F",
"L 	c #131313",
"M 	c #A2A2A2",
"N 	c #A4A4A4",
"O 	c #A6A6A6",
"P 	c #A8A8A8",
"Q 	c #787878",
"R 	c #AAAAAA",
"S 	c #7F7F7F",
"T 	c #868686",
"U 	c #ACACAC",
"V 	c #A5A5A5",
"W 	c #3A3A3A",
"X 	c #8D8D8D",
"Y 	c #505050",
"Z 	c #1F1F1F",
"` 	c #474747",
" .	c #8F8F8F",
"..	c #595959",
"+.	c #424242",
"@.	c #313131",
"#.	c #262626",
"$.	c #303030",
"%.	c #404040",
"&.	c #242424",
"*.	c #0C0C0C",
"=.	c #1A1A1A",
"-.	c #3D3D3D",
";.	c #2F2F2F",
">.	c #252525",
",.	c #3C3C3C",
"'.	c #0E0E0E",
").	c #222222",
"!.	c #323232",
"~.	c #393939",
"                                                                ",
"    . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   ",
"    . + + + + @ # $ % & * = - ; > , ' ) ! ~ { + ] ^ / ( _ : .   ",
"    . + + + + @ $ % & * < - ; [ , ' ) ! ~ { + } . . . . . | .   ",
"    . + + + + @ % 1 * < 2 ; [ , ' 3 ! ~ 4 + } ^ . 5 5 5 . 6 .   ",
"    . + + + + @ 1 * < 2 ; [ 7 ' 3 8 ~ 4 + } 9 / . 5 5 5 . 0 .   ",
"    . + + + + @ a < 2 b [ 7 ' 3 8 ~ 4 c } 9 / d . . . . . e .   ",
"    . + + + + @ f 2 b [ 7 g 3 8 h 4 c } 9 i d j k l m 0 e n .   ",
"    . + + + + @ 2 b o 7 g 3 8 h ! f 2 _ p q r s 6 m t e n u .   ",
"    . + + + + @ b o 7 g v 8 h 7 $ ! q m w x w m q u e n u s .   ",
"    . + + + + @ o > g v ) h ' $ g q 7 . . . . . 7 q y u y z .   ",
"    . + + + + @ > g v ) h A B $ y { . . C 2 d 2 C { D y z p .   ",
"    . + + + + @ , v ) ! A 7 $ ! q E . . + F 5 F + E q p p G .   ",
"    . + + + + @ ' ) ! A { & $ | 7 . . . F 5 5 5 F . 7 D G H .   ",
"    . + + + + @ ) ! ~ { + $ $ z I . . . F 5 5 5 F . I J H K .   ",
"    . + + + + @ ! ~ { + } $ $ K L . . . + F 5 F + . L J K M .   ",
"    . + + + + @ ~ 4 + } 9 $ $ K L . . . C 2 d 2 C . L J q N .   ",
"    . + + + + @ 4 + } 9 / $ $ z I . . . . . . . . . I q N O .   ",
"    . + + + + @ c } 9 i d a $ | 7 . . . . . . . . . 7 q O P .   ",
"    . + + + + @ Q 9 i d j v $ ! q E . . . . . . . E q N P R .   ",
"    . + + + + @ 9 i S j k T B $ y { . . . . . . . { q P R U .   ",
"    . + + + + @ i S j k T m 4 $ g q 7 . . . . . 7 q V k < W .   ",
"    . + + + + @ S ( k T | t X 8 $ ! q m w x w m q Y . Z I `     ",
"    . + + + + @ ( k T | t X  .u _ = 2 _ p q s 4 ..              ",
"    . +., + + @ _ T | 6 X 8 2 @.x . #.$.%.                      ",
"      &.*.=.+.@ c 1 -.;.. =.>.,.                                ",
"            &.*.'.).!.~.                                        ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                "};


//=================================================================

CameraFolderItem::CameraFolderItem(KListView* _parent,
                                   const QString& _name,
                                   const QString& _path,
                                   bool _root)
    : KListViewItem(_parent)
{
    mRoot = _root;
    mFolderName = _name;
    mFolderPath = _path;
    mNumItems = 0;

    KIconLoader iconLoader;

    setText(0,mFolderName);
    setPixmap(0,camera_xpm);
    //setDropEnabled(true);

    fileItemList.setAutoDelete(true);
    fileItemList.clear();
}

CameraFolderItem::CameraFolderItem(KListViewItem* _parent,
                                   const QString& _name,
                                   const QString& _path,
                                   bool _root)
    : KListViewItem(_parent)
{
    mRoot = _root;
    mFolderName = _name;
    mFolderPath = _path;
    mNumItems = 0;

    KIconLoader iconLoader;

    setText(0,mFolderName);
    setPixmap(0,iconLoader.loadIcon("folder",KIcon::Small));
    setDropEnabled(true);

    fileItemList.setAutoDelete(true);
    fileItemList.clear();
}

CameraFolderItem::~CameraFolderItem()
{
    fileItemList.clear();
}

void CameraFolderItem::setOpen(bool open)
{

    if (open) {
        if (isOpen()) return;
        KListViewItem::setOpen(open);
        if (!mRoot) {
            KIconLoader iconLoader;
            setPixmap(0,iconLoader.loadIcon("folder_open",KIcon::Small));
        }
    }
    else {
        if (!isOpen()) return;
        KListViewItem::setOpen(open);
        if (!mRoot) {
            KIconLoader iconLoader;
            setPixmap(0,iconLoader.loadIcon("folder",KIcon::Small));
        }
    }
}

void CameraFolderItem::showNumItems()
{
    QString numItemsString;
    numItemsString.setNum(mNumItems);
    setText(0,mFolderName + " (" + numItemsString + ")");
}

void CameraFolderItem::incrementNumItems(int val)
{
    mNumItems += val;
}

bool CameraFolderItem::containsItem(const QString& name)
{
    QPtrListIterator<CameraFileItem>
                iter(fileItemList);

    bool result = false;

    CameraFileItem* fileItem;
    while ( (fileItem = iter.current()) != 0 ) {

        ++iter;

        if (fileItem->fileInfo()->getName() == name) {
            result = true;
            break;
        }

    }

    return result;

}

void CameraFolderItem::highlight()
{
    if (isRoot()) return;

    QPixmap pix(*pixmap(0));
    QPainter p;
    p.begin(&pix);
    p.fillRect(pix.rect(),QBrush(Qt::green,Qt::Dense4Pattern));
    p.end();
    setPixmap(0,pix);
}

void CameraFolderItem::unHighlight()
{
    if (isRoot()) return;

    KIconLoader iconLoader;

    if (isOpen())
        setPixmap(0,iconLoader.loadIcon("folder_open",KIcon::Small));
    else
        setPixmap(0,iconLoader.loadIcon("folder",KIcon::Small));
}
