#ifndef GENERALSETTINGS_H
#define GENERALSETTINGS_H

#include <qstring.h>
#include <qcolor.h>

class KConfig;

class GeneralSettings {

public:

    GeneralSettings();
    ~GeneralSettings();

    void readSettings();
    void saveSettings();

    void setAlbumPath(const QString& path)
        { mAlbumPath = path; }
    QString getAlbumPath() const
        { return mAlbumPath; }

    void setDefaultIconSize(const QString& size)
        { mDefaultIconSize = size; }
    QString getDefaultIconSize() const
        { return mDefaultIconSize; }

    void setSlideShowDelay(int num)
        { mSlideShowDelay = num; }
    int getSlideShowDelay() const
        { return mSlideShowDelay; }

    void setSlideShowTransitionEffect(bool val)
        { mSlideShowTransitionEffect = val; }
    bool getSlideShowTransitionEffect() const
        { return mSlideShowTransitionEffect; }

    void setSlideShowFileName(const QString& pos)
        { mSlideShowFileName = pos; }
    QString getSlideShowFileName() const
        { return mSlideShowFileName; }

    void setCameraViewBackgroundColor(const QColor& color)
        { mCameraViewBGColor = color; }
    QColor getCameraViewBackgroundColor() const
        { return mCameraViewBGColor; }

    void setUseInternalImageViewer(bool val)
        { mUseInternalImageViewer = val; }
    bool getUseInternalImageViewer() const
        { return mUseInternalImageViewer; }

    void setImageViewer(const QString& name)
        { mImageViewer = name; }
    QString getImageViewer() const
        { return mImageViewer; }

private:

    QString mAlbumPath;
    QString mDefaultIconSize;
    int     mSlideShowDelay;
    bool    mSlideShowTransitionEffect;
    QString mSlideShowFileName;
    QColor  mCameraViewBGColor;
    bool    mUseInternalImageViewer;
    QString mImageViewer;

    KConfig* config;

};

#endif
