/*
 *  Copyright 2016 Marco Martin <mart@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "desktopview.h"

#include <QScreen>

DesktopView::DesktopView(Plasma::Corona *c, QScreen *targetScreen)
    : QWindow(targetScreen)
{
    if (targetScreen) {
        setScreenToFollow(targetScreen);
        setScreen(targetScreen);
        setGeometry(targetScreen->geometry());
    }
}

DesktopView::~DesktopView()
{
}

void DesktopView::setScreenToFollow(QScreen *screen)
{
    if (screen == m_screenToFollow) {
        return;
    }

    m_screenToFollow = screen;
    setScreen(screen);
}

QScreen *DesktopView::screenToFollow() const
{
    return m_screenToFollow;
}
