include(CheckFunctionExists)
include(CheckIncludeFile)
include(CheckTypeSize)

check_include_file("argz.h" HAVE_ARGZ_H)
CHECK_INCLUDE_FILE("alloca.h" HAVE_ALLOCA_H)
CHECK_INCLUDE_FILE("bp-sym.h" HAVE_BP_SYM_H)
CHECK_INCLUDE_FILE("dlfcn.h" HAVE_DLFCN_H)
CHECK_INCLUDE_FILE("direct.h" HAVE_DIRECT_H)
CHECK_INCLUDE_FILE("errno.h" HAVE_ERRNO_H)
CHECK_INCLUDE_FILE("getopt.h" HAVE_GETOPT_H)
CHECK_INCLUDE_FILE("iconv.h" HAVE_ICONV_H)
CHECK_INCLUDE_FILE("inttypes.h" HAVE_INTTYPES_H)
CHECK_INCLUDE_FILE("limits.h" HAVE_LIMITS_H)
CHECK_INCLUDE_FILE("mach-o/dyld.h" HAVE_MACH_O_DYLD_H)
CHECK_INCLUDE_FILE("memory.h" HAVE_MEMORY_H)
CHECK_INCLUDE_FILE("random.h" HAVE_RANDOM_H)
CHECK_INCLUDE_FILE("search.h" HAVE_SEARCH_H)
CHECK_INCLUDE_FILE("signal.h" HAVE_SIGNAL_H)
CHECK_INCLUDE_FILE("stddef.h" HAVE_STDDEF_H)
CHECK_INCLUDE_FILE("stdint.h" HAVE_STDINT_H)
CHECK_INCLUDE_FILE("stdio.h" HAVE_STDIO_H)
CHECK_INCLUDE_FILE("stdlib.h" HAVE_STDLIB_H)
CHECK_INCLUDE_FILE("strings.h" HAVE_STRINGS_H)
CHECK_INCLUDE_FILE("string.h" HAVE_STRING_H)
CHECK_INCLUDE_FILE("sys/bitypes.h" HAVE_SYS_BITYPES_H)
CHECK_INCLUDE_FILE("sys/inttypes.h" HAVE_SYS_INTTYPES_H)
CHECK_INCLUDE_FILE("sys/mman.h" HAVE_SYS_MMAN_H)
CHECK_INCLUDE_FILE("sys/param.h" HAVE_SYS_PARAM_H)
CHECK_INCLUDE_FILE("sys/socket.h" HAVE_SYS_SOCKET_H)
CHECK_INCLUDE_FILE("sys/stat.h" HAVE_SYS_STAT_H)
CHECK_INCLUDE_FILE("sys/time.h" HAVE_SYS_TIME_H)
CHECK_INCLUDE_FILE("sys/types.h" HAVE_SYS_TYPES_H)
CHECK_INCLUDE_FILE("time.h" HAVE_TIME_H)
CHECK_INCLUDE_FILE("unistd.h" HAVE_UNISTD_H)
CHECK_INCLUDE_FILE("wchar.h" HAVE_WCHAR_H)
CHECK_INCLUDE_FILE("wctype.h" HAVE_WCTYPE_H)
CHECK_INCLUDE_FILE("winsock2.h" HAVE_WINSOCK2_H)


CHECK_FUNCTION_EXISTS("argz_count" HAVE_ARGZ_COUNT)
CHECK_FUNCTION_EXISTS("argz_next" HAVE_ARGZ_NEXT)
CHECK_FUNCTION_EXISTS("argz_stringify" HAVE_ARGZ_STRINGIFY)
CHECK_FUNCTION_EXISTS("alloca" HAVE_ALLOCA)
if(MSVC)
    set(HAVE_ALLOCA 1)
endif(MSVC)
CHECK_FUNCTION_EXISTS("asprintf" HAVE_ASPRINTF)
CHECK_FUNCTION_EXISTS("atexit" HAVE_ATEXIT)
CHECK_FUNCTION_EXISTS("canonicalize_file_name" HAVE_CANONICALIZE_FILE_NAME)
CHECK_FUNCTION_EXISTS("CFLocaleCopyCurrent" HAVE_CFLOCALECOPYCURRENT)
CHECK_FUNCTION_EXISTS("fwprintf" HAVE_FWPRINTF)
CHECK_FUNCTION_EXISTS("getcwd" HAVE_GETCWD)
CHECK_FUNCTION_EXISTS("_getcwd" HAVE_GETCWD2)
CHECK_FUNCTION_EXISTS("getegid" HAVE_GETEGID)
CHECK_FUNCTION_EXISTS("geteuid" HAVE_GETEUID)
CHECK_FUNCTION_EXISTS("getgid" HAVE_GETGID)
CHECK_FUNCTION_EXISTS("getopt_long_only" HAVE_GETOPT_LONG_ONLY)
CHECK_FUNCTION_EXISTS("getpagesize" HAVE_GETPAGESIZE)
CHECK_FUNCTION_EXISTS("gettext" HAVE_GETTEXT)
CHECK_FUNCTION_EXISTS("getuid" HAVE_GETUID)
CHECK_FUNCTION_EXISTS("iconv" HAVE_ICONV)
CHECK_FUNCTION_EXISTS("iswblank" HAVE_ISWBLANK)
CHECK_FUNCTION_EXISTS("iswcntrl" HAVE_ISWCNTRL)
CHECK_FUNCTION_EXISTS("lstat" HAVE_LSTAT)
CHECK_FUNCTION_EXISTS("mbrtowc" HAVE_MBRTOWC)
CHECK_FUNCTION_EXISTS("mbsinit" HAVE_MBSINIT)
CHECK_FUNCTION_EXISTS("mbslen" HAVE_MBSLEN)
CHECK_FUNCTION_EXISTS("memchr" HAVE_MEMCHR)
CHECK_FUNCTION_EXISTS("memmove" HAVE_MEMMOVE)
CHECK_FUNCTION_EXISTS("mempcpy" HAVE_MEMPCPY)
CHECK_FUNCTION_EXISTS("mmap" HAVE_MMAP)
CHECK_FUNCTION_EXISTS("mprotect" HAVE_MPROTECT)
CHECK_FUNCTION_EXISTS("munmap" HAVE_MUNMAP)
CHECK_FUNCTION_EXISTS("newlocale" HAVE_NEWLOCALE)
CHECK_FUNCTION_EXISTS("pathconf" HAVE_PATHCONF)
CHECK_FUNCTION_EXISTS("putenv" HAVE_PUTENV)
CHECK_FUNCTION_EXISTS("readlink" HAVE_READLINK)
CHECK_FUNCTION_EXISTS("realpath" HAVE_REALPATH)
CHECK_FUNCTION_EXISTS("setenv" HAVE_SETENV)
CHECK_FUNCTION_EXISTS("setlocale" HAVE_SETLOCALE)
CHECK_FUNCTION_EXISTS("snprintf" HAVE_SNPRINTF)
CHECK_FUNCTION_EXISTS("stpcpy" HAVE_STPCPY)
CHECK_FUNCTION_EXISTS("strcasecmp" HAVE_STRCASECMP)
CHECK_FUNCTION_EXISTS("strdup" HAVE_STRDUP)
CHECK_FUNCTION_EXISTS("strerror_r" HAVE_STRERROR_R)
CHECK_FUNCTION_EXISTS("strnlen" HAVE_STRNLEN)
CHECK_FUNCTION_EXISTS("strtol" HAVE_STRTOL)
CHECK_FUNCTION_EXISTS("strtoul" HAVE_STRTOUL)
CHECK_FUNCTION_EXISTS("tsearch" HAVE_TSEARCH)
CHECK_FUNCTION_EXISTS("uselocale" HAVE_USELOCALE)
CHECK_FUNCTION_EXISTS("wcrtomb" HAVE_WCRTOMB)
CHECK_FUNCTION_EXISTS("wcslen" HAVE_WCSLEN)
CHECK_FUNCTION_EXISTS("wcsnlen" HAVE_WCSNLEN)
CHECK_FUNCTION_EXISTS("wcwidth" HAVE_WCWIDTH)
CHECK_FUNCTION_EXISTS("_NSGetExecutablePath" HAVE__NSGETEXECUTABLEPATH)
CHECK_FUNCTION_EXISTS("__fsetlocking" HAVE___FSETLOCKING)

CHECK_FUNCTION_EXISTS("clearerr_unlocked" HAVE_DECL_CLEARERR_UNLOCKED)
CHECK_FUNCTION_EXISTS("feof_unlocked" HAVE_DECL_FEOF_UNLOCKED)
CHECK_FUNCTION_EXISTS("ferror_unlocked" HAVE_DECL_FERROR_UNLOCKED)
CHECK_FUNCTION_EXISTS("fflush_unlocked" HAVE_DECL_FFLUSH_UNLOCKED)
CHECK_FUNCTION_EXISTS("fgets_unlocked" HAVE_DECL_FGETS_UNLOCKED)
CHECK_FUNCTION_EXISTS("fputc_unlocked" HAVE_DECL_FPUTC_UNLOCKED)
CHECK_FUNCTION_EXISTS("fputs_unlocked" HAVE_DECL_FPUTS_UNLOCKED)
CHECK_FUNCTION_EXISTS("fread_unlocked" HAVE_DECL_FREAD_UNLOCKED)
CHECK_FUNCTION_EXISTS("fwrite_unlocked" HAVE_DECL_FWRITE_UNLOCKED)
CHECK_FUNCTION_EXISTS("getchar_unlocked" HAVE_DECL_GETCHAR_UNLOCKED)
CHECK_FUNCTION_EXISTS("getc_unlocked" HAVE_DECL_GETC_UNLOCKED)
CHECK_FUNCTION_EXISTS("getenv" HAVE_DECL_GETENV)
CHECK_FUNCTION_EXISTS("getopt_clip" HAVE_DECL_GETOPT_CLIP)
CHECK_FUNCTION_EXISTS("optreset" HAVE_DECL_OPTRESET)
CHECK_FUNCTION_EXISTS("program_invocation_name" HAVE_DECL_PROGRAM_INVOCATION_NAME)
CHECK_FUNCTION_EXISTS("program_invocation_short_name" HAVE_DECL_PROGRAM_INVOCATION_SHORT_NAME)
CHECK_FUNCTION_EXISTS("putchar_unlocked" HAVE_DECL_PUTCHAR_UNLOCKED)
CHECK_FUNCTION_EXISTS("putc_unlocked" HAVE_DECL_PUTC_UNLOCKED)
CHECK_FUNCTION_EXISTS("strerror_r" HAVE_DECL_STRERROR_R)
CHECK_FUNCTION_EXISTS("strnlen" HAVE_DECL_STRNLEN)
CHECK_FUNCTION_EXISTS("wcwidth" HAVE_DECL_WCWIDTH)
CHECK_FUNCTION_EXISTS("_snprintf" HAVE_DECL__SNPRINTF)
CHECK_FUNCTION_EXISTS("_snwprintf" HAVE_DECL__SNWPRINTF)
CHECK_FUNCTION_EXISTS("strerror" HAVE_DECL_STRERROR)

CHECK_TYPE_SIZE("ptrdiff_t" BITSIZEOF_PTRDIFF_T)
CHECK_TYPE_SIZE("sig_atomic_t" BITSIZEOF_SIG_ATOMIC_T)
CHECK_TYPE_SIZE("size_t" BITSIZEOF_SIZE_T)
CHECK_TYPE_SIZE("wchar_t" BITSIZEOF_WCHAR_T)
CHECK_TYPE_SIZE("wint_t" BITSIZEOF_WINT_T)

CHECK_TYPE_SIZE("intmax_t" INTMAX_T)

CHECK_TYPE_SIZE("uintmax_t" UINTMAX_T)
if(HAVE_UINTMAX_T)
set(HAVE_STDINT_H_WITH_UINTMAX true)
endif(HAVE_UINTMAX_T)

if(ICONV_SECOND_ARGUMENT_IS_CONST)
    set(HAVE_ICONV_CONST 1)
endif(ICONV_SECOND_ARGUMENT_IS_CONST)

if(NOT HAVE_UINTMAX_T)
    set(uintmax_t "unsigned __int64")
endif(NOT HAVE_UINTMAX_T)
if(NOT HAVE_INTMAX_T)
    set(intmax_t "__int64")
endif(NOT HAVE_INTMAX_T)

if(WINCE)
    set(INTDIV0_RAISES_SIGFPE 1)
endif(WINCE)

if(WIN32)
    set(FILE_SYSTEM_ACCEPTS_DRIVE_LETTER_PREFIX 1)
    set(FILE_SYSTEM_BACKSLASH_IS_FILE_NAME_SEPARATOR 1)
else(WIN32)
    set(FILE_SYSTEM_BACKSLASH_IS_FILE_NAME_SEPARATOR 0)
endif(WIN32)

configure_file(${CMAKE_CURRENT_SOURCE_DIR}/config.h.cmake ${CMAKE_CURRENT_BINARY_DIR}/config.h)

add_definitions(-DHAVE_CONFIG_H -DLIBDIR)