# - Find the native Rasqal includes and library
#
# This module defines
#  RASQAL_INCLUDE_DIR, where to find rasqal.h, etc.
#  RASQAL_LIBRARIES, the libraries to link against to use Rasqal.
#  RASQAL_FOUND, If false, do not try to use Rasqal.

#=============================================================================
#
find_path(RASQAL_INCLUDE_DIR rasqal.h PATH_SUFFIXES rasqal)
find_library(RASQAL_LIBRARIES NAMES rasqal)

# handle the QUIETLY and REQUIRED arguments and set RASQAL_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Rasqal  DEFAULT_MSG  RASQAL_LIBRARIES RASQAL_INCLUDE_DIR)

mark_as_advanced(RASQAL_INCLUDE_DIR RASQAL_LIBRARIES)
