#ifndef _KSOCK_H_
#define _KSOCK_H_

#include <qobject.h>
#include <ksock.h>
#include <Python.h>
#include "../qt/Baseobject.h"


extern "C" void SWIG_MakePtr(char *, void *, char *);


class _Socket : public KSocket, public BaseObject
{
  Q_OBJECT
  
public:
    _Socket( int _sock ) : KSocket(_sock) {
      QObject::connect(this, SIGNAL(readEvent(KSocket *)), this, SLOT(sigReadEvent(KSocket *)));
      QObject::connect(this, SIGNAL(writeEvent(KSocket *)), this, SLOT(sigWriteEvent(KSocket *)));
      QObject::connect(this, SIGNAL(closeEvent(KSocket *)), this, SLOT(sigCloseEvent(KSocket *)));
    };
    _Socket( const char *_host, unsigned short int _port ) : KSocket(_host,_port) {
      QObject::connect(this, SIGNAL(readEvent(KSocket *)), this, SLOT(sigReadEvent(KSocket *)));
      QObject::connect(this, SIGNAL(writeEvent(KSocket *)), this, SLOT(sigWriteEvent(KSocket *)));
      QObject::connect(this, SIGNAL(closeEvent(KSocket *)), this, SLOT(sigCloseEvent(KSocket *)));
    };
    _Socket( const char *_path ) : KSocket(_path) {
      QObject::connect(this, SIGNAL(readEvent(KSocket *)), this, SLOT(sigReadEvent(KSocket *)));
      QObject::connect(this, SIGNAL(writeEvent(KSocket *)), this, SLOT(sigWriteEvent(KSocket *)));
      QObject::connect(this, SIGNAL(closeEvent(KSocket *)), this, SLOT(sigCloseEvent(KSocket *)));
    };
    ~_Socket() {};

public slots:

    void sigReadEvent(KSocket *sock) {
       char temp[128];
       SWIG_MakePtr(temp, (char *) sock, "__Socket_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("readEvent", arg);  
       Py_DECREF(arg);
    };

    void sigWriteEvent(KSocket *sock) {
       char temp[128];
       SWIG_MakePtr(temp, (char *) sock, "__Socket_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("writeEvent", arg);  
       Py_DECREF(arg);
    };

    void sigCloseEvent(KSocket *sock) {
       char temp[128];
       SWIG_MakePtr(temp, (char *) sock, "__Socket_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("closeEvent", arg);  
       Py_DECREF(arg);
    };
};


class _ServerSocket : public KServerSocket, public BaseObject
{
  Q_OBJECT
  
public:
    _ServerSocket( int _port ) : KServerSocket(_port) {
      QObject::connect(this, SIGNAL(accepted(KSocket *)), this, SLOT(sigAccepted(KSocket *)));
    };
    _ServerSocket( const char *_path ) : KServerSocket(_path) {
    };
    ~_ServerSocket() {};

    void sigAccepted(KSocket *sock) {
       char temp[128];
       SWIG_MakePtr(temp, (char *) sock, "__Socket_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("accepted", arg);  
       Py_DECREF(arg);
    };
};

#endif