%module WM

%{
#include "Object.h"
#include <kwm.h>
%}

%include Types.i
%include Constants.i 

%import Object.i


class KWM
{
public:

  static QString getProperties(Window w);
  static QRect setProperties(Window w, const QString &props);

  static void enableSessionManagement(Window w);
  static void setWmCommand(Window w, const QString &command);
  static void setUnsavedDataHint(Window w, bool value);

  static void setMiniIcon(Window w, const QPixmap &pm);
  static void setIcon(Window w, const QPixmap &pm);

  static void setDockWindow(Window w);
  static void setDecoration(Window w, long value);
  enum {noDecoration = 0, normalDecoration = 1, tinyDecoration = 2,
	noFocus = 256};

  static void logout();
  static void refreshScreen();
  static void darkenScreen();

  static void configureWm();

  static int currentDesktop();

  static void raiseSoundEvent(const QString &event);
  static void registerSoundEvent(const QString &event);
  static void unregisterSoundEvent(const QString &event);
};


