%module KStatusbar


%{
#include "KStatusbar.h"
%}


%include Types.i


class _StatusBar : public QFrame 
{
public:
  enum BarStatus { Toggle, Show, Hide };
  enum Position {Top, Left, Bottom, Right, Floating};
  enum InsertOrder {LeftToRight, RightToLeft};

  _StatusBar(QWidget *parent = 0, const char *name = 0 );
  ~_StatusBar();

  int insertItem( const char *text, int ID );
  int insertWidget (QWidget *_widget, int size, int id);
  void removeItem (int id);

  void changeItem( const char *text, int id );
  void setInsertOrder(InsertOrder order);
  void setAlignment(int id, int align);
  void setHeight(int);
  void setBorderWidth(int);
  bool enable( BarStatus stat );
  void message (const char *text, int time=0);
%name(messageWidget)  void message (QWidget *widget, int time=0);
  
  void clear ();

/*   
signals:
  void pressed(int);
  void released(int);
*/
};
