/*
 * kpvm_entity.h
 *
 * Copyright (c) 1998 Michael Kropfberger <michael.kropfberger@gmx.net>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __KPVM_ENTITY_H__
#define __KPVM_ENTITY_H__

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <qobject.h>
#include <qstring.h>

#include <pvm3.h>

/*************************************************************************/
/**
  * @short represents an existing pvm-object out there
  * @author Michael Kropfberger <michael.kropfberger@gmx.net>
**/
class KPvmEntity : public QObject
{ Q_OBJECT

  public:
    /**
      * KPvmEntity has to be constructed with a valid TaskId generated by 
      * spawn(..) or pvm_parent()
    **/
    KPvmEntity(int taskId, QString theHostName, 
                   QObject *parent=0, const char *name=0); 
    
    /**
      * returns the TaskId of this pvm-object
      * @return TaskId
     **/
    int tid() const {return _tid;};

    /**
      * returns the hostname on which this PvmEntity is running
     **/
    QString hostName() const {return _hostName;};


    void dataNotify(int msgtag) { 
         //debug("notified: I got data %i from t%x!",msgtag,_tid);
         emit hasSentData(msgtag);};

  public slots:

  signals:

  /**
    * is emitted when @ref KPvm receives data from the Task represented
    * by this @ref KPvmEntity
    * @param msgtag the msgtag used by the received data
   **/
    void hasSentData(int msgtag); 

  private:
    int _tid;
    QString _hostName;
};

/*************************************************************************/
/**
  * @short represents the parent of the actually running process
  * @author Michael Kropfberger <michael.kropfberger@gmx.net>
**/
class KPvmParent : public KPvmEntity
{ Q_OBJECT

  public:
  /**
    *
   **/
    KPvmParent(int taskId, QString theHostName,
                 QObject *parent=0, const char *name=0); 


};

/*************************************************************************/
/**
  * @short represents one of the childs spawned by the actually running process
  * @author Michael Kropfberger <michael.kropfberger@gmx.net>
**/
class KPvmChild : public KPvmEntity
{ Q_OBJECT

  public:
  
  /**
    *
   **/
    KPvmChild(int taskId, QString theHostName,
               QObject *parent=0, const char *name=0); 

};

#endif
