/*
 * vartuple.cpp
 *
 * Copyright (c) 1998 Michael Kropfberger <michael.kropfberger@gmx.net>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "vartuple.h"
#include "vartuple.moc"

void VarTuple::init()
{
  _tag="";
  _type=UNKNOWN;
  _value="";
  
};

VarTuple::VarTuple(QObject *parent , const char *name)
     :QObject(parent,name)
{
 init();
};

VarTuple::VarTuple(QString varTag, QObject *parent, const char *name)
     :QObject(parent,name)
{
  init();
  _tag=varTag;
};

VarTuple::VarTuple(QString varTag, int var, QObject *parent
                                            , const char *name)
     :QObject(parent,name)
{
  init();
  _tag=varTag;
  setValue(var);  
};

VarTuple::VarTuple(QString varTag, long var, QObject *parent
                                            , const char *name)
     :QObject(parent,name)
{
  init();
  _tag=varTag;
  setValue(var);  
};

VarTuple::VarTuple(QString varTag, QString var, QObject *parent
                                            , const char *name)
     :QObject(parent,name)
{
  init();
  _tag=varTag;
  setValue(var);  
};

VarTuple::VarTuple(QString varTag, float var, QObject *parent
                                            , const char *name)
     :QObject(parent,name)
{
  init();
  _tag=varTag;
  setValue(var);  
};

VarTuple::VarTuple(QString varTag, double var, QObject *parent
                                            , const char *name)
     :QObject(parent,name)
{
  init();
  _tag=varTag;
  setValue(var);  
};

QString VarTuple::tag() const
{ return _tag; };

VarTuple::VarType VarTuple::type() const 
{ return _type; };

QString VarTuple::valueToString() const 
{ return _value; }; 

void VarTuple::setValue(int var)
{
  _type=INT;
  _value=_value.setNum(var);
};

void VarTuple::setValue(long var)
{
  _type=LONG;
  _value=_value.setNum(var);
};

void VarTuple::setValue(QString var)
{
  _type=STRING;
  _value=var;
};

void VarTuple::setValue(float var)
{
  _type=FLOAT;
  _value=_value.setNum(var);
};

void VarTuple::setValue(double var)
{
  _type=DOUBLE;
  _value=_value.setNum(var);
};


/***************************************************************************
 * storeValueTo
 */

void VarTuple::storeValueTo(int &var)
{
  if (_type != INT)
    fatal("Convert Problem: wrong type: [%s] is not an INT!"
                  ,(const char *)_value);
  else {
     var=_value.toInt(&OK);
     if ((OK != 0) && (OK==FALSE))
        fatal("Convert Problem [%s]",(const char *)_value);
  }
};

void VarTuple::storeValueTo(long &var)
{
  if (_type != LONG)
    fatal("Convert Problem: wrong type: [%s] is not a LONG!"
                  ,(const char *)_value);
  else {
     var=_value.toLong(&OK);
     if ((OK != 0) && (OK==FALSE))
        fatal("Convert Problem [%s]",(const char *)_value);
  }
};

void VarTuple::storeValueTo(QString &var)
{
  if (_type != STRING)
    fatal("Convert Problem: wrong type: [%s] is not a STRING!"
                  ,(const char *)_value);
  else
     var=_value;
  
};

void VarTuple::storeValueTo(float &var)
{
  if (_type != FLOAT)
    fatal("Convert Problem: wrong type: [%s] is not a FLOAT!"
                  ,(const char *)_value);
  else {
     var=_value.toFloat(&OK);
     if ((OK != 0) && (OK==FALSE))
        fatal("Convert Problem [%s]",(const char *)_value);
  }
};

void VarTuple::storeValueTo(double &var)
{
  if (_type != DOUBLE)
    fatal("Convert Problem: wrong type: [%s] is not a DOUBLE!"
                  ,(const char *)_value);
  else {
     var=_value.toDouble(&OK);
     if ((OK != 0) && (OK==FALSE))
        fatal("Convert Problem [%s]",(const char *)_value);
  }
};




/***************************************************************************
 * data
 */
QString VarTuple::data() const
{
  QString s;
  s.sprintf("%s%c%d%c%s",(const char *)_tag,SEPARATOR
                        ,_type
                        ,SEPARATOR,(const char *)_value);
  return s;
};

void VarTuple::setData(QString varTuple) 
{
  if (varTuple.isEmpty())
     fatal("Got an empty VarTuple String");
  int i=varTuple.find(SEPARATOR);
  _tag=varTuple.left(i);
  _type=(VarTuple::VarType)varTuple.mid(i+1,1).toInt();
  _value=varTuple.remove(0,varTuple.find(SEPARATOR,i+1)+1);
}
