/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include <stdio.h>
#include <qtc/qtc.h>

void intprint (int i)
{
    printf ("Intprint called with argument %d\n",i);
}

int main(int argc,char **argv)
{
    qt_QApplication *app;
    qt_QListBox *p1;
    qt_Slot *p2;
    qt_Signal *p3;

    /* Create an application */
    app=qt_new_QApplication(argc,argv);

    /* A listbox, so we can generate some signals*/

    p1=qt_new_QListBox (0,"Main dialog",0);
    qt_QWidget_setGeometry ((qt_QWidget *)p1,100,100,300,300);
    qt_QListBox_insertItem1 (p1,"item0",-1);
    qt_QListBox_insertItem1 (p1,"item1",-1);
    qt_QListBox_insertItem1 (p1,"item2",-1);
    qt_QListBox_insertItem1 (p1,"item3",-1);

    p2=qt_new_IntSlot(intprint);
    p3=qt_new_Signal();

    qt_QObject_connect((qt_QObject *)p1,SIGNAL(highlighted(int)),
                       (qt_QObject *)p3,SIGNAL(intSignal(int)));
    
    qt_QObject_connect((qt_QObject *)p3,SIGNAL(intSignal(int)),
                       (qt_QObject *)p2,SLOT(intSlot(int)));

    printf ("Emitting a signal with value 4\n");
    qt_emitInt(p3,4);
    printf ("Try selecting a few items from the list, please.\n\n");

    /* Enter the event loop */
    qt_QWidget_show ((qt_QWidget *)p1);
    qt_QApplication_setMainWidget(app,(qt_QWidget *)p1);
    qt_QApplication_exec(app);

    /* Avoid warnings ;-) */
    exit (0);
}