#include "CheckBox.h"


CheckBox::CheckBox(Widget *parent=0, const char *name=0)
{
  if(parent)
    checkbox = new QCheckBox(parent->widget, name);
  else
    checkbox = new QCheckBox(NULL, name);

  Button::setWidget((QButton*)checkbox);
}

CheckBox::CheckBox(const char *text, Widget *parent, const char *name=0)
{
  if(parent)
    checkbox = new QCheckBox(text, parent->widget, name);
  else
    checkbox = new QCheckBox(text,NULL,name);

  Button::setWidget((QButton*)checkbox);
}

bool CheckBox::isChecked() const
{
  return checkbox->isChecked();
}

void CheckBox::setChecked(int check)
{
  checkbox->setChecked(check);
}

QSize CheckBox::sizeHint() const
{
  return checkbox->sizeHint();
}

