#include "GroupBox.h"

GroupBox::GroupBox (Widget* parent=0, const char* name=0)
{
  if(parent)
    groupbox = new QGroupBox(parent->widget,name);
  else
    groupbox = new QGroupBox(NULL,name);

  setWidget(groupbox);
}

GroupBox::GroupBox (const char* title, Widget* parent=0, const char* name=0)
{
  if(parent)
    groupbox = new QGroupBox(title,parent->widget,name);
  else
    groupbox = new QGroupBox(title,NULL,name);

  setWidget(groupbox);
}
 
GroupBox::GroupBox (char abstractdummyvariable) /* abstract constructor */
{
}


void GroupBox::setWidget(QGroupBox *_groupbox)
{
  groupbox = _groupbox;
  Frame::setWidget((QFrame*)groupbox);
}

const char* GroupBox::title () const
{
  return groupbox->title();
}

void GroupBox::setTitle (const char* title)
{
  groupbox->setTitle(title);
}
 
int GroupBox::alignment () const
{
  return groupbox->alignment();
}

void GroupBox::setAlignment (int align)
{
  groupbox->setAlignment(align);
}
 

