//
#include "Object.h"


Object::Object()
  : QObject()
{
  
}

Object::~Object()
{
}

void Object::connect(char *signal, PyObject *slot, PyObject *slotowner)
{
  // Python memory management
  Py_INCREF(slot);

  Connection *c = new Connection;
  c->signal = strdup(signal);
  c->slotowner = slotowner;
  c->slot = slot;
  connections.append(c);

  //  printf("Connected signal %s to object at %p\n function ", signal, slotowner);
  // PyObject_Print(slot, stdout, Py_PRINT_RAW);
  //printf("\n");
}

void Object::disconnect(PyObject *slot, char *signal)
{
  // Not yet implemented!
}

#ifdef emit
#undef emit
#endif

void Object::emit(char *signal, PyObject *args)
{
  //  printf("Signal: %s   Args: ",signal);
  //  PyObject_Print(args,stdout,Py_PRINT_RAW);
  //  printf("\n");
  
  Connection *c;
  for(c = connections.first(); c!=0; c = connections.next())
    {
      if(strcmp(c->signal, signal) == 0)
	{
	  if(c->slotowner)
	    {			// This should pass `self'!
	      PyEval_CallObject(c->slot, args);
	    }
	  else
	    {
	      PyEval_CallObject(c->slot, args);
	      
	    }
	}
    }
}

void Object::slotConnected(Object *from, char *signal, PyObject *slot)
{
}

void Object::slotDisconnect(Object *from, char *signal, PyObject *slot)
{
}

void Object::cleanup()
{
}


