#ifndef OBJECT
#define OBJECT

#include <Python.h>
#include <qlist.h>
#include <qobject.h>

#ifdef emit
#undef emit
#endif

class Object;

struct Connection
{
  char *signal;
  PyObject *slotowner;
  PyObject *slot;
};

class Object : public QObject
{
  Q_OBJECT;
public:
  Object();
  ~Object();

  void connect(char *signal, PyObject *slot, PyObject *slotowner=0);
  void disconnect(PyObject *slot, char *signal = "");
  void emit(char *signal, PyObject *args);

private:
  void slotConnected(Object *from, char *signal, PyObject *slot);
  void slotDisconnect(Object *from, char *signal, PyObject *slot);
  void cleanup();

  QList< Connection > connections;
};

#endif
