// kproptext.h

#if !defined KPROPTEXT_H
#define KPROPTEXT_H

#include <qlabel.h>
#include <qlined.h>
#include <kconfig.h>

/** This class provides a label with a line edit.
  * The widget is resized when the font changes.
  */
class KPropText : public QLabel
{
	Q_OBJECT
	
public:
	/** Constructor. 'text' is the text of the label.
	  * 'perc' is the percentage of space reserved for the line edit widget.
	  */
	KPropText( QWidget *parent, const char *text, int perc, const char *key=0, const char *group=0, KConfig *config=0, const char *name=0 );

	/** Destructor. deletes the line edit widget. */
	virtual ~KPropText();
	
	/** Set the contents of the line edit widget.
	  * If no arguments are given, defaults to empty text.
	  */
	void setContents( const char * text=0 );

	/** Returns the contents of the line edit widget. */
	const char *getContents();

	/** set the group to modify */
	void setGroup( const char *group );

	/** Returns the group to be modified */
	const char *getGroup();

	/** set the key to modify */
	void setKey( const char * );

	/** returns the Key to be modified */
	const char *getKey();

	/** Set the KConfig object to operate upon. */
	void setKConfig( KConfig * );

	/** Returns the current KConfig object */
	KConfig *getKConfig();

public slots:
	/** Write the config key value. . */
	virtual void setConfig();

	/** Read the config key value into the widget. 
	  * . 
	  */
	virtual void getConfig();

protected:
	/** Handles resize events for the line edit widget. */
	virtual void resizeEvent( QResizeEvent *rev );

	/** This method is called after a font change.
	  * It will call sizeUpdate() to resize the widget to contain
	  * the new font.
	  */
	virtual void fontChange( const QFont &oldfont );

	/** Sets the minimum size to fit the font. */
	void sizeUpdate();

	QLineEdit *lineEdit;
	int percentage;
	KConfig *ConfigObject;
	QString Group, Key;
};

#endif //KPROPTEXT_H

