/*  This file is part of the KDE libraries
    Copyright (C) 1998 Jrgen Hochwald (juergen.hochwald@privat.kkf.net

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.*/



#ifndef KWRDLG_H
#define KWRDLG_H
#include <stdio.h>
#include <qpushbt.h>
#include <ktopwidget.h>
#include <qlabel.h>
#include <krestrictedline.h>
#include <qchkbox.h>
#include <qspinbox.h>
#include <kspinbox.h>
#include <qradiobutton.h>
#include <ktmainwindow.h>
#include "kwr/kwr.h"

class WrTestDlg : public KTMainWindow {
   Q_OBJECT
public:
   WrTestDlg(QWidget* parent=0, const char* name=0);
   KWindRose* WR;
   
private slots:
   void ApplyBtnClick();
   void TestBtnClick();
   void Col1BtnClick();
   void Col2BtnClick();
   void Col3BtnClick();
   void Col4BtnClick();
   void Col5BtnClick();
   void ValChange(float Val);
   void DirSetIndexBtnClick();
   void DirSetTextBtnClick();
   
private:
   QPushButton *ApplyBtn, *TestBtn;
   QSpinBox *DetailSpin, *WidthSpin;
   KListSpinBox *ArrowSpin, *DirTextSpin;
   QWidget *Col1Rect,*Col2Rect,*Col3Rect,*Col4Rect;
   QPushButton *Col1Btn,*Col2Btn,*Col3Btn,*Col4Btn,  *Col5Btn;
   QCheckBox *EditCheck;
   QLineEdit *ResEdit, *DirEdit;
   QRadioButton *ValidRad, *NodataRad, *InvalidRad;
};

#endif
