#include <qpainter.h>

#include "kxosquare.moc"

KXOSquare::KXOSquare (QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  thestate = None;
}

void
KXOSquare::paintEvent (QPaintEvent *)
{
  QPainter p (this);

  p.drawRect (rect());

  switch (thestate)
    {
    case X:
      p.setPen (QPen (Qt::blue, 3));
      p.drawLine (rect().x(), rect().y(), 
		  rect().x()+rect().width(), rect().y()+rect().height());
      p.drawLine (rect().x(), rect().y()+rect().height(),
		  rect().x()+rect().width(), rect().y());
      break;
    case O:
      p.setPen (QPen (Qt::red, 3));
      p.drawEllipse (rect());
      break;
    }
}

void
KXOSquare::mousePressEvent (QMouseEvent *mouseevent)
{
  switch (mouseevent->button())
    {
    case Qt::LeftButton:
      emit changeRequest (X);
      break;
    case Qt::RightButton:
      emit changeRequest (O);
      break;
    }

}

void
KXOSquare::newState (State state)
{
  thestate = state;
  update();
}
