#ifndef __KSAVEACROSS_H__
#define __KSAVEACROSS_H__

#include <ktmainwindow.h>

/**
 * KSaveAcross
 * This application saves its data across sessions.  Its data is
 *  the contents of a QLineEdit.
 **/
class KSaveAcross : public KTMainWindow
{
 Q_OBJECT
 public:
  KSaveAcross (const char *name=0);

 public slots:
   /**
    * Change the font used by qlineedit.
    **/
  void slotChangeFont();
 
 protected:
  QLineEdit *qlineedit;

  /**
   * Ask the user if he/she wants to save the document.
   **/
  bool queryClose();

  /**
   * Save the chosen font.
   **/
  void saveProperties (KConfig *kconfig);
  /**
   * Read the chosen font.
   **/
  void readProperties (KConfig *kconfig);

};

#endif
