/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2006-2009 Eike Hein <hein@kde.org>
*/

// FIXME KF5 Port: ViewTree TODO: Close buttons, DND, seperator painting.

#ifndef VIEWTREE_H
#define VIEWTREE_H

#include <QStyledItemDelegate>
#include <QTreeView>
#include <QPointer>

class ChatWindow;
class ViewTree;

class ViewTreeDelegate : public QStyledItemDelegate
{
    Q_OBJECT

    public:
        explicit ViewTreeDelegate(QObject *parent = 0);
        ~ViewTreeDelegate() override;

        QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const override;
        QSize preferredSizeHint(const QModelIndex& index) const;

        void paint(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const override;

    private:
        ViewTree* m_view;
};

class ViewTree : public QTreeView
{
    Q_OBJECT

    public:
        explicit ViewTree(QWidget *parent);
        ~ViewTree() override;

        void setModel(QAbstractItemModel *model) override;

        bool dropIndicatorOnItem() const;

    public Q_SLOTS:
        void updateAppearance();
        void selectView(const QModelIndex &index);

    Q_SIGNALS:
        void sizeChanged() const;
        void showView(ChatWindow* view) const;
        void closeView(ChatWindow* view) const;
        void showViewContextMenu(QWidget* widget, const QPoint& point) const;

    protected:
        bool event(QEvent* event) override;
        void paintEvent(QPaintEvent* event) override;
        void drawRow(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const override;
        void resizeEvent(QResizeEvent* event) override;
        void mousePressEvent(QMouseEvent* event) override;
        void mouseReleaseEvent(QMouseEvent* event) override;
        void mouseMoveEvent(QMouseEvent *event) override;
        void dragEnterEvent(QDragEnterEvent *event) override;
        void dragMoveEvent(QDragMoveEvent *event) override;
        void contextMenuEvent(QContextMenuEvent* event) override;
        void wheelEvent(QWheelEvent* event) override;
        void keyPressEvent(QKeyEvent* event) override;

    private Q_SLOTS:
        void selectionChanged(const QItemSelection& selected, const QItemSelection& deselected) override;

    private:
        QPointer<ChatWindow> m_pressedView;

        QPoint m_pressPos;

        int m_accumulatedWheelDelta;
        bool m_lastWheelDeltaDirection;
};

#endif
