/*
   Copyright (c) 2019-2020 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2 of the License or
   ( at your option ) version 3 or, at the discretion of KDE e.V.
   ( which shall act as a proxy as in section 14 of the GPLv3 ), any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "snippetattachmentwidgettest.h"
#include "snippets/snippetattachmentwidget.h"
#include <QHBoxLayout>
#include <QLineEdit>
#include <QTest>
#include <QToolButton>
QTEST_MAIN(SnippetAttachmentWidgetTest)

SnippetAttachmentWidgetTest::SnippetAttachmentWidgetTest(QObject *parent)
    : QObject(parent)
{
}

void SnippetAttachmentWidgetTest::shouldHaveDefaultValues()
{
    MailCommon::SnippetAttachmentWidget w;

    QHBoxLayout *layout = w.findChild<QHBoxLayout *>(QStringLiteral("layout"));
    QVERIFY(layout);
    QCOMPARE(layout->contentsMargins(), QMargins(0, 0, 0, 0));

    QLineEdit *mLineEdit = w.findChild<QLineEdit *>(QStringLiteral("lineedit"));
    QVERIFY(mLineEdit);
    QVERIFY(mLineEdit->text().isEmpty());
    QVERIFY(mLineEdit->isReadOnly());
    QVERIFY(!mLineEdit->placeholderText().isEmpty());

    QToolButton *button = w.findChild<QToolButton *>(QStringLiteral("button"));
    QVERIFY(button);
    QVERIFY(!button->text().isEmpty());
    QVERIFY(!button->toolTip().isEmpty());
}
