/*
 *  Copyright 2014  Andreas Cord-Landwehr <cordlandwehr@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) version 3, or any
 *  later version accepted by the membership of KDE e.V. (or its
 *  successor approved by the membership of KDE e.V.), which shall
 *  act as a proxy defined in Section 6 of version 3 of the license.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef DOCUMENTTYPESWIDGET_H
#define DOCUMENTTYPESWIDGET_H

#include "libgraphtheory/edgetype.h"
#include "libgraphtheory/models/nodetypemodel.h"
#include "libgraphtheory/models/edgetypemodel.h"
#include <QWidget>

class QPushButton;

class DocumentTypesWidget : public QWidget
{
    Q_OBJECT
public:
    explicit DocumentTypesWidget(QWidget *parent);
    ~DocumentTypesWidget() = default;

public Q_SLOTS:
    void setDocument(GraphTheory::GraphDocumentPtr document);

private Q_SLOTS:
    void onNodeTypeColorChanged(const QModelIndex &index, const QColor &color);
    void onNodeTypeNameChanged(const QModelIndex &index, const QString &name);
    void onCreateNodeType();
    void onEdgeTypeColorChanged(const QModelIndex &index, const QColor &color);
    void onEdgeTypeNameChanged(const QModelIndex &index, const QString &name);
    void onEdgeTypeDirectionChanged(const QModelIndex &index, const GraphTheory::EdgeType::Direction &direction);
    void onCreateEdgeType();

private:
    GraphTheory::GraphDocumentPtr m_document;
    GraphTheory::NodeTypeModel m_nodeTypeModel;
    GraphTheory::EdgeTypeModel m_edgeTypeModel;
    QPushButton *m_createNodeTypeButton;
    QPushButton *m_createEdgeTypeButton;
};

#endif
