/************************************************************************
 * kinst - KDE Application Installer - kifoptions.inc                   *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef MAX_ADDITIONAL_PACKAGES
#define MAX_ADDITIONAL_PACKAGES 5
#endif

#ifndef KIFOPTIONS_VERSION_MAJ
#define KIFOPTIONS_VERSION_MAJ 1
#endif

#ifndef KIFOPTIONS_VERSION_MIN
#define KIFOPTIONS_VERSION_MIN 2
#endif

#ifndef KIFOPTIONS_FIELD_LENGTH
#define KIFOPTIONS_FIELD_LENGTH 1024
#endif

#ifndef MAXDEPRPM
#define MAXDEPRPM 20
#endif

// The KIF-Options structure
struct tKIFOptions
{
  char ProgramName[KIFOPTIONS_FIELD_LENGTH];
  char CheckPriorFile[KIFOPTIONS_FIELD_LENGTH];
  char CheckPriorRPM[KIFOPTIONS_FIELD_LENGTH];
  char SourceFileType[10];
  char SourceFile[KIFOPTIONS_FIELD_LENGTH];
  char ReadMeFile[KIFOPTIONS_FIELD_LENGTH];
  char GraphicsFile[KIFOPTIONS_FIELD_LENGTH];
  char IconFile[KIFOPTIONS_FIELD_LENGTH];
  char ExecBinary[KIFOPTIONS_FIELD_LENGTH];
  char KDELNKAdditions[KIFOPTIONS_FIELD_LENGTH];
  char DefaultInstallPath[KIFOPTIONS_FIELD_LENGTH];
  char RelocatablePackage[KIFOPTIONS_FIELD_LENGTH];
  char DefaultMenuEntry[KIFOPTIONS_FIELD_LENGTH];
  char PreInstallScript[KIFOPTIONS_FIELD_LENGTH];
  char DoneInstallScript[KIFOPTIONS_FIELD_LENGTH];
  char RecommendReboot[KIFOPTIONS_FIELD_LENGTH];
  char LibraryDir[KIFOPTIONS_FIELD_LENGTH];
  char VersionMaj;
  char VersionMin;
  char VersionRel;
  char URL[KIFOPTIONS_FIELD_LENGTH];
  char RPMDepCount;
  char RPMDepName[MAXDEPRPM][KIFOPTIONS_FIELD_LENGTH];
  char RPMDepFullName[MAXDEPRPM][KIFOPTIONS_FIELD_LENGTH];
  char RPMDepLocation[MAXDEPRPM][KIFOPTIONS_FIELD_LENGTH];

  char ProgramName2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char CheckPriorFile2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char CheckPriorRPM2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char SourceFile2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char IconFile2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char ExecBinary2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char KDELNKAdditions2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char PreInstallScript2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char DoneInstallScript2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char LibraryDir2[MAX_ADDITIONAL_PACKAGES][KIFOPTIONS_FIELD_LENGTH];
  char VersionMaj2[MAX_ADDITIONAL_PACKAGES];
  char VersionMin2[MAX_ADDITIONAL_PACKAGES];
  char VersionRel2[MAX_ADDITIONAL_PACKAGES];
  char RPMDepCount2[MAX_ADDITIONAL_PACKAGES];
  char RPMDepName2[MAXDEPRPM][MAX_ADDITIONAL_PACKAGES]
                  [KIFOPTIONS_FIELD_LENGTH];
  char RPMDepFullName2[MAXDEPRPM][MAX_ADDITIONAL_PACKAGES]
                      [KIFOPTIONS_FIELD_LENGTH];
  char RPMDepLocation2[MAXDEPRPM][MAX_ADDITIONAL_PACKAGES]
                      [KIFOPTIONS_FIELD_LENGTH];
};
