/************************************************************************
 * kinst - KDE Application Installer - main.cpp                         *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <kapp.h>
#include <qmessagebox.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>
#include <kcmdlineargs.h>
#include <qstring.h>

#include "locale.h"
#include "gui.h"
#include "package.h"
#include "stringfunc.h"

#include "../config.h"

#define URL_LENGTH 65535

void help(void)
{
  printf(_i18n("Usage: kinst -f infofile\n"));
  printf(_i18n("   or: kinst -p packagefile\n"));
  printf(_i18n("   or: kinst -url packagefile_url\n"));
  printf(_i18n("       kinst --version  prints program version\n"));
}

int main(int argc, char *argv[])
{
  int kapp_err;
  char given_filename[FILENAME_MAX];
  char given_url[URL_LENGTH];
  char s[FILENAME_MAX];
  char tempdir[FILENAME_MAX];
  int i;
  tKIFPackage* KIFPackage;
  KFileDialog* FileSelection;
  bool removetmp;
  QString downloadtemp;
  char arg[FILENAME_MAX];
  char *_argv[1];

  strncpy(arg, argv[0], FILENAME_MAX);
  _argv[0] = arg;

  kapp_err = 1;

  strcpy(given_filename, "");

  removetmp = false;

  KApplication* a;

  KCmdLineArgs::init(1, _argv, PACKAGE, "installer", VERSION);

  a = new KApplication(argc, argv);

  kinstMainWidget* kinstAppWidget=new kinstMainWidget();

  FileSelection = new KFileDialog(getenv("HOME"), "*", kinstAppWidget,
				  "FileSelection", false);
  FileSelection->hide();

  // Check command line arguments for filename
  if(argc < 2)
    {
      help();
      return(127);
    }

  if(strcmp(argv[1], "--version") == 0)
    {
      printf("kinst ");
#ifdef VERSION
      printf(VERSION);
#else
      printf("(unknown version)");
#endif
      printf("\n");
      exit(0);
    }

  if(strcmp(argv[1], "--help") == 0)
    {
      help();
      return(127);
    }

  for(i = 1;i <= argc;i++)
    {
      if((strcmp(argv[i], "-f") == 0) && (argc > i+1))
	strncpy(given_filename, argv[i+1], FILENAME_MAX);
      if((strcmp(argv[i], "-f") == 0) && !(argc > i+1))
	{
	  qstrncpy(given_filename,
		   FileSelection->getOpenFileName(getenv("HOME"),
						  "*.kif *.KIF",
						  kinstAppWidget,
						  "KIFSelection"),
		   FILENAME_MAX);
	  FileSelection->hide();
	  if(given_filename[0] != '/') exit(0);
	}
    }

  for(i = 1;i <= argc;i++)
    {
      if(strcmp(argv[i], "-p") == 0)
	{
	  if(argc > i+1) strncpy(given_filename, argv[i+1], FILENAME_MAX);
	  else
	    {
	      qstrncpy(given_filename,
		       FileSelection->getOpenFileName(getenv("HOME"),
						      "*.kip *.KIP",
						      kinstAppWidget,
						      "KIFSelection"),
		       FILENAME_MAX);
	      FileSelection->hide();
	      if(given_filename[0] != '/') exit(0);
	    }
	  KIFPackage = new tKIFPackage(given_filename);
	  tmpnam(tempdir);
	  mkdir(tempdir, 0);
	  removetmp = true;
	  kapp_err = KIFPackage->UnpackAllFiles(tempdir);
	  KIFPackage->getTempKIF(s);
	  delete KIFPackage;
	  // Handle package errors
	  if(kapp_err == 2)
	    {
	      fprintf(stderr, _i18n("Error Opening given package file %s\n"), 
given_filename);
	      QMessageBox::warning(kinstAppWidget, "kinst",
				   _i18n("Error Opening given package file"));
	      return(124);
	    }
	  strncpy(given_filename, tempdir, FILENAME_MAX);
	  _strncat(given_filename, "/", FILENAME_MAX);
	  _strncat(given_filename, s, FILENAME_MAX);
#ifdef _DEBUG_
	  printf("main:  KIF to use: %s\n", given_filename);
#endif
	}
    }

  for(i = 1;i <= argc;i++)
    {
      if(strcmp(argv[i], "-url") == 0)
	{
	  if(argc > i+1) strncpy(given_url, argv[i+1], URL_LENGTH);
	  else
	    {
	      qstrncpy(given_url,
		       FileSelection->getOpenURL(getenv("HOME"),
						 "*.kip *.KIP",
						 kinstAppWidget,
						 "").path(),
		       URL_LENGTH);
	      FileSelection->hide();
	      if(given_url[0] == 0) exit(0);
	    }
#ifdef _DEBUG_
	  printf("main:  Opening URL %s\n", given_url);
#endif
	  if(!KIO::NetAccess::download(given_url, downloadtemp))
	    {
	      QMessageBox::warning(kinstAppWidget, "kinst",
				   _i18n("Error Opening given URL"));
	      return(124);
	    }
	  qstrncpy(given_filename, downloadtemp, FILENAME_MAX);
	  KIFPackage = new tKIFPackage(given_filename);
	  tmpnam(tempdir);
	  mkdir(tempdir, 0);
	  removetmp = true;
	  kapp_err = KIFPackage->UnpackAllFiles(tempdir);
	  KIFPackage->getTempKIF(s);
	  delete KIFPackage;
	  // Handle package errors
	  if(kapp_err == 2)
	    {
	      fprintf(stderr, _i18n("Error Opening given package file %s\n"), 
given_filename);
	      QMessageBox::warning(kinstAppWidget, "kinst",
				   _i18n("Error Opening given package file"));
	      return(124);
	    }
	  strncpy(given_filename, tempdir, FILENAME_MAX);
	  _strncat(given_filename, "/", FILENAME_MAX);
	  _strncat(given_filename, s, FILENAME_MAX);
#ifdef _DEBUG_
	  printf("main:  KIF to use: %s\n", given_filename);
#endif
	  remove(downloadtemp);
	}
    }

  if(strlen(given_filename) == 0)
    {
      help();
      return(127);
    }

  if(kapp_err == 3)
    {
      fprintf(stderr, _i18n("Error Unpacking installation set\n"));
      QMessageBox::warning(kinstAppWidget, "kinst",
			   _i18n("Error Unpacking installation set\n"));
      return(125);
    }

  // Run the Application
  a->setMainWidget(kinstAppWidget);
  if(!kinstAppWidget->kinstMainWidgetKIFinit(given_filename))
    {
      fprintf(stderr, _i18n("Error Opening given control file %s\n"), 
given_filename);
      QMessageBox::warning(kinstAppWidget, "kinst",
			 _i18n("Error Opening given control file"));
      return(126);
    }

  // Check for root prior of showing the main widget
  if(getuid() != 0)
    {
      fprintf(stderr, _i18n("Must be root to use kinst.\n"), given_filename);
      QMessageBox::information(kinstAppWidget, "kinst",
			       _i18n("Must be root to use kinst.\n"));
      return(127);
    }

  kinstAppWidget->show();
#ifdef _DEBUG_
  QString applocale;
  char applocale2[256];
  KLocale* klocale;
  klocale = new KLocale("kinst");
  applocale = klocale->language();
  // applocale = klocale->getLocale("LC_ALL");
  qstrncpy(applocale2, applocale, 256);
  printf("main: AppLocale: %s\n", applocale2);
#endif
  kapp_err = a->exec();

  if(removetmp)
    {
      strcpy(s, "rm -f -r ");
      strcat(s, tempdir);

#ifdef _DEBUG_
      printf("main: Trying to remove temporary files\n");
#endif
      system(s);
    }

  return(kapp_err);
}



