/************************************************************************
 * kinst - KDE Application Installer - stringfunc.cpp                   *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <qstring.h>

#include "stringfunc.h"

// Strncpy replacement
// returns char pointer just like strncpy
char* _strncpy(char* dest, const char* source, long int length)
{
  strncpy(dest, source, length);
  return(dest);
} // somehow this is bogus...

// Strncat replacement
// returns char pointer just like strncat
char* _strncat(char* dest, const char* source, long int length)
{
  strncat(dest, source, length - strlen(dest));
  return(dest);
}

// Append char to string
// returns char pointer to new string
char* _strappend(char* dest, char c, long int length)
{
  long int i;

  i = strlen(dest);

  dest[i] = c;
  dest[i + 1] = 0;

  return(dest);
}
