/************************************************************************
 * kcreateinst - part of kinst package - tgzview.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "tgzview.h"

#ifndef MIN_WIDTH
#define MIN_WIDTH 400
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 400
#endif

#ifndef EOL
#define EOL 10
#endif

// MOC
#include "tgzview.moc"

tTGZViewDlg::tTGZViewDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{
  // General properties
  setCaption(_i18n("kcreateinst - Choose file in TGZ"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create Head
  Head = new QLabel(this);
  Head->setText(_i18n("Please choose a file:"));
  Head->show();

  // Create Contents
  Contents = new QListBox(this);
  Contents->clear();
  Contents->show();

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create ok button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));
}

void tTGZViewDlg::resizeEvent(QResizeEvent*)
{
  // Resize Head
  Head->setGeometry(10,
		    10,
		    width()-20,
		    15);

  // Resize Contents
  Contents->setGeometry(10,
			27,
			width()-20,
			height()-70);

  // Resize cancel_button
  cancel_button->setGeometry(width()-100,
			     height()-35,
			     90,
			     30);

  // Resize ok button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);
}

QString tTGZViewDlg::getFilePath(QString TGZ)
{
  QString Command;
  char readline[65535];

  if(strlen(TGZ) <= 0) return("");

  Contents->clear();

  FilePath = "";

  // Collect the filenames

  tmpnam(tempfilename);

  Command = "tar tfz \"";
  Command += TGZ;
  Command += "\" > ";
  Command += tempfilename;

  system(Command);

  tempfile = NULL;
  tempfile = fopen(tempfilename, "r");
  if(tempfile == NULL) return("");

  while(!feof(tempfile))
    {
      fgets(readline, 65535, tempfile);
      if(feof(tempfile)) strcpy(readline, "");
      if(readline[strlen(readline)-1] == EOL)
	readline[strlen(readline)-1] = 0;
      Contents->insertItem(readline);
    }

  if(tempfile != NULL) fclose(tempfile);

  remove(tempfilename);

  show();

  return(FilePath);
}

void tTGZViewDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void tTGZViewDlg::ok_pressed()
{
  FilePath = Contents->text(Contents->currentItem());

  hide();
}

void tTGZViewDlg::cancel_pressed()
{
  FilePath = "";

  hide();
}
