#include "MainApp.h"
#include <qkeycode.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <qtstream.h>
#include <qmenudta.h>
#include <qpopmenu.h>
#include <qlayout.h>
#include "stringres.h"
#include "MainWindow.h"
#include "cmdline.h"
#include "setupdlg.h"
#include "helpers.h"
#include "settings.h"
#include "klocale.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef rcsid
static const char rcsid[]="$Id: MainApp.cpp,v 2.27 2001/04/29 11:14:07 ral Exp $";
//const char*mainapp_rcs(){return rcsid;}
#endif

#define Inherited KMainWindow

CMainApp::CMainApp(const char* name,bool _first)
	:Inherited(0,name ),CSendMessage()
{
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(124);
    setCaption(head);

    int id;
    MenuBar = menuBar();
    MainWidget = new CMainWindow( this, "MainWidget" );
    MainWidget->set_msg_ptr(this);
    file = new QPopupMenu;
    file->insertItem(GET_TEXT(64),MainWidget,SLOT(connectSql()),CTRL+Key_C);
    file->insertItem(i18n(CStringRes::get_string(47)),MainWidget,SLOT(disconnectSql()),CTRL+Key_D);
    file->insertItem(i18n(CStringRes::get_string(145)),MainWidget,SLOT(RestoreLastConnect()));

    file->insertItem(i18n(CStringRes::get_string(48)),MainWidget,SLOT(clearOutput()));
    file->setCheckable(TRUE);
    logf = file->insertItem(i18n(CStringRes::get_string(49)),this,SLOT(set_LogFileName()));
    file->insertSeparator();
    file->insertItem(i18n(CStringRes::get_string(122)),this,SLOT(new_window()),CTRL+Key_N);
    file->insertSeparator();
    file->insertItem(i18n(CStringRes::get_string(123)),this,SLOT(windowClose()),CTRL+Key_W);
    file->insertItem(GET_TEXT(149),this,SLOT(raus_hier()),CTRL+Key_Q);
    MenuBar->insertItem(i18n(CStringRes::get_string(109)),file);
    db_menu = new QPopupMenu;
    id = db_menu->insertItem(i18n(CStringRes::get_string(50)));
    db_menu->connectItem(id,MainWidget,SLOT(drop_db()));
    id = db_menu->insertItem(i18n(CStringRes::get_string(110)));
    db_menu->connectItem(id,MainWidget,SLOT(rename_table()));
    id = db_menu->insertItem(i18n(CStringRes::get_string(51)));
    db_menu->connectItem(id,MainWidget,SLOT(drop_table()));
    db_menu->insertSeparator();
    id = db_menu->insertItem(i18n(CStringRes::get_string(52)));
    db_menu->connectItem(id,MainWidget,SLOT(flush_cache()));
    id = db_menu->insertItem(i18n(CStringRes::get_string(53)));
    db_menu->connectItem(id,MainWidget,SLOT(close_tables()));
    id = db_menu->insertItem(i18n(CStringRes::get_string(54)));
    db_menu->connectItem(id,MainWidget,SLOT(new_log()));
    db_menu->insertSeparator();
    id = db_menu->insertItem(i18n(CStringRes::get_string(55)));
    db_menu->connectItem(id,MainWidget,SLOT(reload_grants()));
    QString e_str = "&";e_str+=CStringRes::get_string(56);
    id = db_menu->insertItem(e_str);
    db_menu->connectItem(id,MainWidget,SLOT(shutdown()));
    id = db_menu->insertItem(GET_TEXT(150));
    db_menu->connectItem(id,MainWidget,SLOT(sql_Edit()));
    MenuBar->insertItem(i18n(CStringRes::get_string(57)),db_menu);
    setup_menu = new QPopupMenu;
    id = setup_menu->insertItem(GET_TEXT(151));
    setup_menu->connectItem(id,this,SLOT(layout_setup()));
    MenuBar->insertItem(i18n(CStringRes::get_string(146)),setup_menu);

    MenuBar->insertSeparator();

    KPopupMenu *help = helpMenu();
    menuBar()->insertItem( GET_TEXT(111), help );

    KIconLoader iconload;
    QPixmap icon = iconload.loadIcon("kmysqladmin",KIcon::Desktop);
    setIcon(icon);
    connect(MainWidget,SIGNAL(connected(const char*)),this,SLOT(connected_to_server(const char*)));
    connect(MainWidget,SIGNAL(disconnected()),this,SLOT(disconnected_from_server()));
    setIcon(kapp->icon());
    //KWM::setMiniIcon(winId(),kapp->getMiniIcon());

    MainWidget->setGeometry( 2, 2, 366, 186 );
    MainWidget->setMinimumSize( 370, 190 );
    MainWidget->setMaximumSize( 32767, 32767 );

    //setView(MainWidget,FALSE);
    setCentralWidget(MainWidget);
    disconnected_from_server();
    setMinimumSize( 370, 190 );
    setMaximumSize( 32767, 32767 );
    KConfig * k = KGlobal::config();
    k->setGroup("common");
    int w,h;
    QString ws,hs;
    ws = k->readEntry("width","0");
    hs = k->readEntry("height","0");
    w = ws.toInt();
    h = hs.toInt();
    if (w && h) {
	if ( (h-10) > 0)
	    MainWidget->resize(w,h-10);
	resize(w,h);
    }
    if (_first) {
	if (kapp->isRestored()) {
	    MainWidget->RestoreLastConnect();
	} else {
	}
    }
}

CMainApp::~CMainApp()
{
    filepointer.close();
}
  
void CMainApp::append_message(const char*text)
{
    if (text && strlen(text) != 0 ) {
	MainWidget->append_message(text);
	if (filepointer.isOpen()) {
	    QTextStream t( &filepointer );
	    t << text << "\n";
	    filepointer.flush();
	}
    }
}

void CMainApp::append_message(const std::string&message)
{
    append_message(message.c_str());
}

void CMainApp::set_LogFileName()
{
    QString s;
    if (logfile.isEmpty()) {
	s = KFileDialog::getOpenFileName(0,"*.log");
	if (!s.isEmpty()) {
	    logfile = s;
	    filepointer.setName(s);
	    if (!filepointer.open(IO_WriteOnly | IO_Append))
		logfile = "";
	}
    }
    else {
	logfile = "";
	filepointer.close();
    }
    file->setItemChecked( logf,(logfile.isEmpty()?0:1) );
}

void CMainApp::disconnected_from_server()
{
    unsigned int i;
    int j;

    for (i = 0; i <= db_menu->count();i++) {
	j = db_menu->idAt(i);
        if (j != -1) {
	    db_menu->setItemEnabled(j,FALSE);
        }
    }
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(124);
    setCaption(head);
}

void CMainApp::connected_to_server(const char*msg)
{
    unsigned int i;
    int j;

    for (i = 0; i <= db_menu->count();i++) {
	j = db_menu->idAt(i);
        if (j != -1) {
	    db_menu->setItemEnabled(j,TRUE);
        }
    }
    QString head = CStringRes::get_string(125);head+=" - ";
    if (msg) {
	head+=msg;
    } else {
	head+="connected";
    }
    setCaption(head);
}

void CMainApp::new_window()
{
    CMainApp*dlg = new CMainApp;
    dlg->show();
}

void CMainApp::raus_hier()
{
    KMainWindow * w;
    if (memberList) {
	for (w=memberList->first();w;w=memberList->first()) {
	    if (!w->close()) 
		break;
	}
    }
}

void CMainApp::windowClose()
{
    MainWidget->close();
    close();
}

bool CMainApp::queryExit()
{
    return true;
}

bool CMainApp::queryClose()
{
    queryExit();
    KConfig*k = KGlobal::config();
    k->setGroup("common");
    int w,h;
    w = width();
    h = height();
    QString s;
    s.setNum(w);
    k->writeEntry("width",s);
    s.setNum(h);
    k->writeEntry("height",s);
    return true;
}

void CMainApp::layout_setup()
{
    CSetupDlg layout_setup;
    std::string name;
    int size,weight,charset;
    bool it;
    if (layout_setup.exec()) {
	QFont fix_font = layout_setup.fixed_font();
	QFont nprop_font = layout_setup.nonprop_font();
	FontToParameter(fix_font,name,size,weight,it,charset);
	GlobalSettings.set_fixed_font(name,size,weight,it,charset);
	FontToParameter(nprop_font,name,size,weight,it,charset);
	GlobalSettings.set_nprop_font(name,size,weight,it,charset);
        GlobalSettings.StatusPolltime(layout_setup.StatusPolltime());
        GlobalSettings.ThreadPolltime(layout_setup.ThreadPolltime());
    }
}
