/**********************************************************************

	--- Qt Architect generated file ---

	File: changetablename.cpp
	Last generated: Sun Oct 10 04:59:05 1999

 *********************************************************************/

#include "changetablename.h"
#include "globals.h"
#include <qmsgbox.h>
#include "stringres.h"
#include "qstring.h"
#include "my_sql.h"
#include "qlistbox.h"
#include "qpushbutton.h"
#include "qstring.h"
#include "qcombobox.h"
#include "qlineedit.h"

#ifndef rcsid
static const char rcsid[]="$Id: changetablename.cpp,v 2.8 2001/04/08 12:24:47 ral Exp $";
//const char*changettablename_rcs(){return rcsid;}
#endif

#define Inherited CChangeTableNameData

CChangeTableName::CChangeTableName(smart_pointer<CMySql>& _sql_server, QWidget* parent, const char* name )
    :Inherited( parent, name,true)
{
    sql_server = _sql_server;
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(128);
    setCaption(head);
    db_list.resize(0);
    table_list.resize(0);
    if(sql_server && sql_server->get_db_list("%",db_list)) {
	for (stringlist::iterator p = db_list.begin();p!=db_list.end();++p) {
	   DB_List->insertItem(p->c_str());
	}
	db_selected(0);
    }
}


CChangeTableName::~CChangeTableName()
{
}

void CChangeTableName::change_name()
{
    if (table_list.size()==0 || db_list.size()==0) {
	return;
    }
    if (sql_server->rename_table(DB_List->currentText(),Table_List->currentText(),NewNameEdit->text())) {
	accept();
    } else {
	display_error_box();
    }
}

void CChangeTableName::name_changed(const QString&text)
{
    if (text.isEmpty() || table_list.size()==0) {
	ChangeNameButton->setEnabled(false);
	return;
    }
    ChangeNameButton->setEnabled(table_list.find(text.latin1())==0);
}

void CChangeTableName::db_selected(int index)
{
    if (index < 0 || db_list.size()==0) {
	return;
    }
    Table_List->clear();
    ChangeNameButton->setEnabled(false);
    if (!sql_server->get_table_list("%",DB_List->currentText().latin1(),table_list)||
	table_list.size()==0) {
	return;
    }
    for (stringlist::iterator p = table_list.begin();p!=table_list.end();++p) {
	Table_List->insertItem(p->c_str());
    }
    table_selected(0);
}

void CChangeTableName::table_selected(int index)
{
    if (index < 0 || table_list.size()==0) {
	return;
    }
    std::string c_db = DB_List->currentText().latin1();
    NewNameEdit->setEnabled(!sql_server->is_system_db(c_db.c_str()));
    c_db = Table_List->currentText();
    NewNameEdit->setText(c_db.c_str());
    name_changed(c_db.c_str());
}
