/*
 *  KSeg
 *  Copyright (C) 1999 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */


#include "G_refs.H"
#include "G_ref.H"
#include <qptrdict.h>

struct topSortState
{
  G_ref *element;
  int child;
};

void G_refs::appendUnique(G_ref *r)
{
  if(findRef(r) == -1) append(r);
}
void G_refs::update()
{ 
  int i; 
  for(i = 0; i < (int)count(); i++) at(i)->update();
}


bool G_refs::operator==(G_refs &r)
{
  if(count() != r.count()) return false;

  int i; 
  for(i = 0; i < (int)count(); i++) if(at(i) != r.at(i)) return false;

  return true;
}


//utility macros to be used inside of topologicalSort:
#define PUSH_STATE { if(stackDepth >= (int)stateStack.size()) stateStack.resize(stackDepth * 2); stateStack[stackDepth++] = state; }
#define POP_STATE { state = stateStack[--stackDepth]; }
#define ADD_REF(_ref) { append(_ref); if(count() > Primes[sizeIndex]) added.resize(Primes[++sizeIndex + 1]); added.insert(_ref, &dummy); }

void G_refs::topologicalSort(G_refs toBeAdded, const G_ref *target)
{
  //this function creates a list such that every object comes after all its parents.
  //all children of objects in the list will be inserted into the list.
  //uses a hash table to keep track of what's been added.
  //target is when only a certain object needs to be updated (like for loci).  It's NULL by default.

  clear(); 
  
  //hash table init:
  int dummy;
  QPtrDict<int> added(Primes[0]);
  int sizeIndex = 0; //index into the primes table

  //state:
  topSortState state;
  QArray<topSortState> stateStack(50);
  int stackDepth = 0;

  //main loop:
  int i;
  for(i = 0; i < (int)toBeAdded.count(); i++) {
    if(added[toBeAdded[i]]) continue;
    state.element = toBeAdded[i];

    for(state.child = 0; ; state.child++) {

      if(state.child == 0 && target && !target->isAncest(state.element)) {
	POP_STATE
	continue;
      }

      if(state.child >= (int)state.element->getChildren().count()) {
	ADD_REF(state.element)
	if(stackDepth == 0) break; // to within the outer loop
	POP_STATE
	continue;
      }

      if(state.element != target && !added[state.element->getChildren()[state.child]]) {
	PUSH_STATE
	state.element = state.element->getChildren()[state.child];
	state.child = -1; //1 will get added to it when continue is called
	continue;
      }

    }

  }

  reverse(begin(), end());
  
}
#undef PUSH_STATE
#undef POP_STATE
#undef ADD_REF



#define ADD_REF(_ref, _where) \
  { _where.append(_ref); if(added.count() > Primes[sizeIndex]) added.resize(Primes[++sizeIndex + 1]); added.insert(_ref, &dummy); }

//this horrible procedure is for doing reverse dragging.
void G_refs::buildReverse(G_refs x)
{
  G_refs values;
  G_refs tmp, tmp1;
  // tmp stores reverse queue, tmp1--indirect parents.
  int i, flag;
  
  if(x.count() == 0) return;
  
  // if it's a lone constrained point, add it and go away
  if(x.count() == 1 && x[0]->getType() == G_POINT && x[0]->getDescendType() ==
     G_CONSTRAINED_POINT) {
    append(x[0]);
    return;
  }
  
  
  //hash table init:
  int dummy;
  QPtrDict<int> added(Primes[0]);
  int sizeIndex = 0; //index into the primes table

  // add all free points to queue and to tmp.
  for(i = 0; i < (int)x.count(); i++) {
    if(x[i]->getType() & G_VALUE) {
      values.append(x[i]);
      x.removeRef(x[i]);
      i--; continue;
    } 

    if((x[i]->getType() == G_POINT &&
	x[i]->getDescendType() == G_FREE_POINT)) {
      append(x[i]);
      ADD_REF(x[i], tmp);
      x.removeRef(x[i]);
      i--;
    }
  }

  // add_reverse everything else

  for(i = 0; i < (int)x.count(); i++) {
    addReverse(x[i], tmp, tmp1, sizeIndex, added);
  }

  flag = 0; // flag = 0 means this is the last loop

  // the search begins!
  // we try to use a new loop that goes thru even if flag = 1.  Hopefully,
  // it's faster and doesn't cause problems

  for(i = 0; flag || i < (int)tmp1.count(); i++) {
    int j;
    G_ref *r = 0;

    //if go back to old loop, this is not necessary
    if((int)tmp1.count() == i) {
      flag = 0;
      i = 0;
    }

    if(added[tmp1[i]]) {
      j = tmp.findRef(tmp1[i]);
      // j does 50 different things. Here, it keeps track
      // of where in direct parents an indirect parent was
      // found.  We first look in there to save time.
      r = tmp[j];
    }
    else {	//if it's not a direct parent, may be it's a descendant
      // of one of the things that we move.

      for(j = 0; j < (int)count(); j++) {
	if(tmp1[i]->isAncest(at(j))) {
	  r = tmp1[i];
	  break;
	}
      }
      if(j == (int)count()) j = -1;	// if not found, set j as flag
    }

    //r stores the indirect parent

    if(j != -1) {	// if the indirect parent in question is moved
      // by our queue
      int k, l, to_skip;

      for(k = 0; k < (int)r->getChildren().count(); k++) {
	if(!added[r->getChildren()[k]]) continue;
	// We have to find the dependent child in tmp
	// to see if it's got any more parents in tmp1
	// and add all of them (with add_reverse) to tmp,
	// removing them from tmp1.

	//if the r is direct parent of current child, skip
	to_skip = 0;
	for(l = 0; l < (int)r->getChildren()[k]->getParents().count(); l++) {
	  if(r->getChildren()[k]->getParents()[l] == r) {
	    if(r->getChildren()[k]->isDirectParent(l)) to_skip = 1;
	    else if(to_skip) { // if double parent, add twice
	      // it's better than no times.
	      to_skip = 0;
	      break;
	    }
	  }
	}
	if(to_skip) continue;
 
	// now go through parents of child of r and if it's
	// in tmp1 (indirect) and not yet added (not in tmp)
	// add it with add_reverse(keeping in tmp1) and set
	// the flag to go another loop.  that way objects
	// that are indirect parents of several objects
	
	for(l = 0; l < (int)r->getChildren()[k]->getParents().count(); l++) {
	  if(tmp1.find(r->getChildren()[k]->getParents()[l]) != -1) {
	    //semi-experimental: if the parent is the other
	    //segment in a ratio, don't add it.
	    if(r->getType() == G_SEGMENT && r->getChildren()[k]->getParents()[l] != r &&
	       r->getChildren()[k]->getDescendType() == G_SCALED)
	      continue;
	    //add it and if it is not already in tmp, set flag
	    if(addReverse(r->getChildren()[k]->getParents()[l], tmp, tmp1, sizeIndex, added))
	      flag = 1;
	  }
	}
      } // end loop on children
    } // end if conflict
  } // end loop on tmp1

  //now remove all the "values" and add the ones that were in x (now in measures)
  for(i = 0; i < (int)count(); i++) {
    if(at(i)->getType() & G_VALUE) {
      remove(i);
      i--;
    }
  }

  for(i = 0; i < (int)values.count(); i++) {
    append(values[i]);
  }

  return;
}


bool G_refs::addReverse(G_ref * x, G_refs &tmp, G_refs &tmp1, int &sizeIndex, QPtrDict<int> &added)
// tmp is direct parents, tmp1 -- indirect.  x is what to add, this--final queue.
{
  int i, j;

  int dummy;


  if(added[x]) return false;

  ADD_REF(x, tmp);
  
  for(j = (int)tmp.count() - 1; j < (int)tmp.count(); j++) {	//keep on adding until done
    //if we get descendents of measures, delete them from the if.
    if(tmp[j]->getParents().count() == 0) {
      // no parents -- then itself direct parent
      if(find(tmp[j]) == -1) append(tmp[j]);
      continue;
    }
    for(i = 0; i < (int)tmp[j]->getParents().count(); i++) { // add all parents
      if(tmp[j]->isDirectParent(i)) {
	if(!added[tmp[j]->getParents()[i]]) {
	  ADD_REF(tmp[j]->getParents()[i], tmp);
	}
      }
      else {	// not a direct parent so add to tmp1
	if(tmp1.find(tmp[j]->getParents()[i])) tmp1.append(tmp[j]->getParents()[i]);
      }
    }
  }
  
  return true;
}
