/***************************************************************************
                          slideLine.cpp  -  description
                             -------------------
    begin                : Thu Mar 15 2001
    copyright            : (C) 2001 by Haavard Froeiland
    email                : haavard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "slideLine.h"

float SlideLine::offset = 0;

SlideLine::SlideLine(QWidget *parent, const char *name)
          :QWidget( parent, name )
{
  pixmap=0;
  pos=0;
  font = QFont("adobe-courier", 20);
  needRecreate=true;

  timer = new QTimer(this,"timer");
  connect( timer, SIGNAL(timeout()),SLOT(slide()));
  timer->start(100,false);
}

void SlideLine::slide()
{
  int dPos;
  if(width()<pixmapSize)
  {
    dPos=((width()-pixmapSize)*(offset) - pos)/3;
    pos+=dPos;
  }
//  cout << dPos << endl;
  repaint(false);
}

void SlideLine::setText(QString t)
{
  text=t;
  textChanged=true;

  repaint(false);
}

void SlideLine::setPixmapSize(QString t)
{
  QFontMetrics fontMetrics( font );
  pixmapSize=fontMetrics.width(t)+50;
  needRecreate=true;
}

void SlideLine::paintEvent( QPaintEvent * )
{
  if (needRecreate)
  {
    if (pixmap!=0)
      delete pixmap;

    pixmap = new QPixmap(pixmapSize-2, height()-2);

    //Start with the right offset
    if(width()>=pixmapSize)
    {
      pos=((width()-pixmapSize)/2);
    }
    else
    {
      pos=(width()-pixmapSize)*(offset);
    }

    QPainter painter;
    painter.begin( this );
      painter.eraseRect(rect());
    painter.end();

    needRecreate=false;
    textChanged=true;
  }

  // if the text has changed we will draw the new text on the back ground image.
  if (textChanged)
  {
    QPainter painter;
    painter.begin(this);
      painter.drawLine(0,0,width(),0);
      painter.drawLine(0,height()-1,width(),height()-1);
    painter.end();

    painter.begin (pixmap, this);
      painter.fillRect (pixmap->rect(),QColor(255,255,255));
      painter.setFont( font );
      painter.drawText(20,0,pixmapSize,pixmap->height(),QPainter::AlignLeft | QPainter::AlignVCenter,text);
    painter.end();
  }
  bitBlt (this, pos+1, 1, pixmap);
}

void SlideLine::resizeEvent (QResizeEvent *)
{
  needRecreate=true;
}


