/***************************************************************************
                          touchline.h  -  description
                             -------------------
    begin                : Sun Dec 10 2000
    copyright            : (C) 2000 by Haavard Froeiland
    email                : haavard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TOUCHLINE_H
#define TOUCHLINE_H

#include <qlineedit.h>
#include <qlabel.h>


#include "touchlecture.h"
#include "touchLineLayout.h"
#include "slideLine.h"

class TouchLine: public TouchLineLayout
{
  Q_OBJECT
private:
  unsigned int pos;
  QString teacherLine;
  QString studentLine;
  TouchLecture *lecture;

public:
  TouchLine(QWidget *parent=0, const char *name=0,TouchLecture *myLecture=0);
	~TouchLine();

public slots:
  void setTeacherLine(const QString&);
  void getNextLine();

signals:
  void isError();
  void isOk();
  void nextKey(const QChar&);
  void stopKTouch();
  void startKTouch();
  void endOfLine();
  void teacherLineChanged(const QString&);

protected:
  void keyPressEvent(QKeyEvent * e );

  void focusOutEvent(QFocusEvent * e);

  void focusInEvent(QFocusEvent * e);

};

#endif



