/***************************************************************************
                          cpluginmanager.cpp
                      -------------------
    description          :
    begin                : Mon May 15 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cpluginmanager.h"

#include <dlfcn.h>
#include <stdlib.h>
#include <iostream.h>
#include <qdir.h>
#include <kapp.h>
#include "debug.h"
#include "kmudplugin.h"



CPluginManager::CPluginManager(KmudAPI* api)
{
	kmudapi=api;
	pluginlist.setAutoDelete(true);
}


CPluginManager::~CPluginManager()
{
	unloadAllPlugins();
	pluginlist.clear();
}


void CPluginManager::searchPlugins()
{
	QString	librarypath,token;
	QStrList pluginpaths;
	QDir dir;
	QString pluginfile;
	QStrList direntries,pluginfilenames;
	int i,j;
	PluginInfo* info;

	// look for *_kmudplg.so files in the following dirs (this order):
	// $LD_LIBRARY_PATH		    - for plugins coders (no need to "make install" all the time)
	// $HOME/.kde/lib/kmud/		- update plugin wihtout update of kmud
	// $KDEDIR/lib/kmud/			- normal "make install"

	librarypath=QString(getenv("LD_LIBRARY_PATH"));
	i = librarypath.find(":");
	while (i>=0)
	{
		token=librarypath.left(i);
		if (!token.isEmpty())
			pluginpaths.append(token);
		librarypath.replace(0,i+1,"");
		i = librarypath.find(":");
	}
	if (!librarypath.isEmpty())
		pluginpaths.append(librarypath);


	pluginpaths.append(KApplication::localkdedir()+"/lib/kmud/");
	pluginpaths.append(QString(getenv("KDEDIR"))+"/lib/kmud/");

	for (i=0;i<(int)pluginpaths.count();i++)
	{
		dir.setPath(pluginpaths.at(i));
		dir.setNameFilter("*_kmudplg.so");
		if (dir.exists() && dir.isReadable())
		{
			direntries=*dir.entryList();
			for (j=0;j<(int)direntries.count();j++)
			{
				pluginfile=direntries.at(j);	
				if (!pluginfilenames.contains(pluginfile))
				{
					pluginfilenames.append(pluginfile);
					info = new PluginInfo;
					info->filename = pluginfile;
					info->pathfilename = QString(dir.path())+"/"+pluginfile;
					info->state = UNLOADED;
					info->pointer = NULL;
					pluginlist.append(info);
//					KDEBUG1(KDEBUG_INFO,kmud_pluginmanager,"found plugin: %s",pluginfullfiles.at(i));	
					cout << "PluginManager: found plugin: " << info->pathfilename << endl;
				}
			}
		}
	}
}


bool CPluginManager::loadPlugin(QString filename)
{
	PluginInfo* info;
	int i;
	void* handle=NULL;
	KmudPlugin* (*create_function)(void);
	char* error;
	bool b;

	// search plugin
	b=false;
	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			b=true;
			break;
		}
	}
	if (!b) return false;

	// already loaded or running
	if (info->state!=UNLOADED) return false;

	// load it and try to resolve symbols immeadiatly
	handle = dlopen(info->pathfilename,RTLD_NOW);
	if (!handle)
	{
	error = dlerror();
	info->state=UNLOADED;
	b=false;
	cerr << "PluginManager: could not dlopen: " << error << endl;
	}
	else
	{
		create_function = (KmudPlugin* (*)(void)) dlsym( handle, "create" ) ;
		error = dlerror();
		if (error==NULL)
		{
			info->pointer = (*create_function) () ;
			info->state=LOADED;
			info->handle=handle;
			b=true;
			cout << "PluginManager: " << info->pointer->getName() << " loaded. " << endl;
		}
		else
		{
			dlclose(handle);
			info->state=UNLOADED;
			b=false;
			cerr << "PluginManager: dlsym error: " << error << endl;
		}
	}

	return b;
}

bool CPluginManager::startPlugin(QString filename)
{
	PluginInfo* info;
	int i;
	bool b;

	// search plugin
	b=false;
	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			b=true;
			break;
		}
	}
	if (!b) return false;

	// already running
	if (info->state==RUNNING) return false;

	// load if unloaded
	if (info->state==UNLOADED)
		loadPlugin(filename);

	// init and run
	info->pointer->init(kmudapi);
	info->pointer->start();
	info->state=RUNNING;

	return true;
}

bool CPluginManager::stopPlugin(QString filename)
{
	PluginInfo* info;
	int i;
	bool b;

	// search plugin
	b=false;
	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			b=true;
			break;
		}
	}
	if (!b) return false;

	// can't stop because not running
	if (info->state!=RUNNING) return false;

	info->pointer->stop();
	info->state=LOADED;

	return true;
}


bool CPluginManager::unloadPlugin(QString filename)
{
	PluginInfo* info;
	int i;
	bool b;
	char* error;
	QString name;

	// search plugin
	b=false;
	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			b=true;
			break;
		}
	}
	if (!b) return false;

	// stop first
	if (info->state==RUNNING)
	 stopPlugin(filename);

	// get name for later output before unloading
	name=info->pointer->getName();

	// close it
	dlclose(info->handle);
	error = dlerror();
	if (error==NULL)
	{
		info->state=UNLOADED;
		info->handle=NULL;
		info->pointer = NULL;
		cout << "PluginManager: " << name << " unloaded. " << endl;
		b=true;
	}
	else
	{
		cerr << "PluginManager: dlclose error: " << error << endl;
		b=false;
	}

	return b;
}


bool CPluginManager::unloadAllPlugins()
{
	PluginInfo* info;
	int i;
	bool b;

	b=true;
	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->state!=UNLOADED)
		{
			if (unloadPlugin(info->filename)==false)
				b=false;
		}
	}

	return b;
}


PluginList CPluginManager::getAllPlugins()
{
 return pluginlist;
}


PluginList CPluginManager::getRunningPlugins()
{
	PluginList list;
	PluginInfo* info;
	int i;

	// search plugin
	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->state==RUNNING)
		{
			list.append(info);
		}
	}

	return list;
}

bool CPluginManager::isPluginUnloaded(QString filename)
{
	int i;
	PluginInfo* info;

	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			if (info->state==UNLOADED) return true;
			if (info->state==LOADED) return false;
			if (info->state==RUNNING) return false;
		}
	}
	return false;
}

bool CPluginManager::isPluginLoaded(QString filename)
{
	int i;
	PluginInfo* info;

	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			if (info->state==UNLOADED) return false;
			if (info->state==LOADED) return true;
			if (info->state==RUNNING) return true;
		}
	}
	return false;
}

bool CPluginManager::isPluginRunning(QString filename)
{
	int i;
	PluginInfo* info;

	for (i=0;i<(int)pluginlist.count();i++)
	{
		info = pluginlist.at(i);
		if (info->filename==filename)
		{
			if (info->state==UNLOADED) return false;
			if (info->state==LOADED) return false;
			if (info->state==RUNNING) return true;
		}
	}
	return false;
}

