/***************************************************************************
                          cmapzone.h
                      -------------------
    description          :
    begin                : Sun Dec 3 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPZONE_H
#define CMAPZONE_H

#include "cmaproom.h"
#include "cmaptext.h"
#include "cmapelement.h"

class CMapRoom;
class CMapText;
class CMapZone;

/**This class is used to store all the different maps for the mud.
  *For example, the maps for different levels
  *@author John-Paul Stanford
  */
class CMapLevelList
{
public:
	/** The constructor for the map list */
	CMapLevelList() { }
	/** Get the list of rooms */
	QList<CMapRoom> *getRoomList(void) 		{ return &roomList; }
	QList<CMapText> *getTextList(void)		{ return &textList; }
	QList<CMapZone> *getZoneList(void)		{ return &zoneList; }	
private:
	QList<CMapRoom> roomList;
	QList<CMapText> textList;
	QList<CMapZone> zoneList;	
};

/**Used to store information on a map zone
  *@author John-Paul Stanford
  */
class CMapZone : public CMapElement
{
public: 
	CMapZone(QString zoneName,signed int x,signed int y, signed int level,CMapZone *mapZone);
	~CMapZone();
	
	/** Used to set the name of the zone */
	void setName (QString zoneName);
	/** Used get the zone name */
	QString getName(void);	
	/** Get a list of levels in the zone */
	QList<CMapLevelList> *getLevels(void);

	virtual void paint(QPainter *p,CMapZone *currentZone);
	virtual void dragPaint(QPainter *p,int offsetx,int offsety,CMapZone *currentZone);
	virtual void lowerPaint(QPainter *p,CMapZone *currentZone);
	virtual void higherPaint(QPainter *p,CMapZone *currentZone);
	virtual elementTyp getElementType(void)     { return ZONE; }
	virtual CMapElement *copy(void);	
	
	void setLevel(signed int level)             { mapLevel = level; }
	signed int  getLevel(void)                  { return mapLevel;  }
	CMapZone *getZone(void)                     { return zone; }
	void setZone(CMapZone *mapZone)             { zone = mapZone; }
	
	void setEditMode(bool edit);

	void setX(int x);			
	void setY(int y);		
	int  getX(void)                             { return xpos; }
	int  getY(void)                             { return ypos; }
	
	void moveBy(int x, int y);		

	virtual void read(KCMapFile* kcmfile);
	virtual void write(KCMapFile* kcmfile);
			
private:
	/** The name of the zone */
	QString name;
	
	/** The level that the zone is in */
	int mapLevel;
	int xpos,ypos;
	CMapZone *zone;
	
	/** This is a list of all the maps for this mud */
	QList<CMapLevelList> mapLevelList;

};

#endif
