/***************************************************************************
                          dlgmaptextproperties.cpp  -  description
                             -------------------
    begin                : Tue Sep 26 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgmaptextproperties.h"

#include <X11/Xlib.h>

DlgMapTextProperties::DlgMapTextProperties(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	setCaption(i18n("Text Properties"));

	initDialog();
	fillFamilyCombo();
	
	if (lstFamily->currentItem()==-1)
		lstFamily->setCurrentItem(0);
		
	lstFamily->centerCurrentItem();	
	
	lstSize->insertItem( "4" );
  	lstSize->insertItem( "5" );
	lstSize->insertItem( "6" );
	lstSize->insertItem( "7" );
	lstSize->insertItem( "8" );
	lstSize->insertItem( "9" );
	lstSize->insertItem( "10" );
	lstSize->insertItem( "11" );
	lstSize->insertItem( "12" );
	lstSize->insertItem( "13" );
	lstSize->insertItem( "14" );
	lstSize->insertItem( "15" );
	lstSize->insertItem( "16" );
	lstSize->insertItem( "17" );
	lstSize->insertItem( "18" );
	lstSize->insertItem( "19" );
	lstSize->insertItem( "20" );
	lstSize->insertItem( "22" );
	lstSize->insertItem( "24" );
	lstSize->insertItem( "26" );
	lstSize->insertItem( "28" );
	lstSize->insertItem( "32" );
	lstSize->insertItem( "48" );
	lstSize->insertItem( "64" );
	
	txtSize->setText("12");
	
	QFont f = txtText->font();
	f.setFamily(lstFamily->text(lstFamily->currentItem()));
	f.setPointSize(12);
	txtText->setFont(f);
	
	lstSize->setCurrentItem(8);
	lstSize->centerCurrentItem();	
	
	txtText->setText("Enter your text here");
	
	connect (cmdCancel,SIGNAL(clicked()),SLOT(reject()));
	connect (cmdOk,SIGNAL(clicked()),SLOT(accept()));
	connect (lstFamily,SIGNAL(highlighted(int)),SLOT(slotFamilySelected(int)));
	connect (lstSize,SIGNAL(highlighted(int)),SLOT(slotSizeSelected(int)));	
	connect (txtSize,SIGNAL(textChanged(const char *)),SLOT(slotSizeChanged(const char *)));
	connect (chkBold,SIGNAL(clicked()),SLOT(slotBoldClicked()));
	connect (QCheckBox_2,SIGNAL(clicked()),SLOT(slotItalicClicked()));
	connect (cmdColour,SIGNAL(changed ( const QColor & )),SLOT(slotColourChanged ( const QColor & )));
}

DlgMapTextProperties::~DlgMapTextProperties(){
}


bool DlgMapTextProperties::loadKDEInstalledFonts(void)
{

	QString fontfilename;

	fontfilename = KApplication::localkdedir() + "/share/config/kdefonts";

	QFile fontfile(fontfilename);

	if (!fontfile.exists())
		return false;

	if(!fontfile.open(IO_ReadOnly))
	{
		return false;
	}

	if (!fontfile.isReadable())
		return false;


	QTextStream t(&fontfile);

	while ( !t.eof() )
	{
		QString s = t.readLine();
		s = s.stripWhiteSpace();
		if(!s.isEmpty())
		{
			lstFamily->insertItem( s ,-1 );
			lstFamily->setCurrentItem(lstFamily->count()-1);
		}
	}

	fontfile.close();

	return true;
}

void DlgMapTextProperties::fillFamilyCombo(void)
{

	int numFonts;
	Display *kde_display;
	char** fontNames;
	char** fontNames_copy;
	QString qfontname;

  QStrList fontlist(TRUE);

  kde_display = XOpenDisplay( 0L );

  // now try to load the KDE fonts

  bool have_installed = loadKDEInstalledFonts();

  // if available we are done, the kde fonts are now in the family_combo

  if (have_installed)
    return;

  fontNames = XListFonts(kde_display, "*", 32767, &numFonts);
  fontNames_copy = fontNames;

  for(int i = 0; i < numFonts; i++){

    if (**fontNames != '-'){

      // The font name doesn't start with a dash -- an alias
      // so we ignore it. It is debatable whether this is the right
      // behaviour so I leave the following snippet of code around.
      // Just uncomment it if you want those aliases to be inserted as well.

      fontNames ++;
      continue;
    };

    qfontname = "";
    qfontname = *fontNames;
    int dash = qfontname.find ('-', 1, TRUE); // find next dash

    if (dash == -1) { // No such next dash -- this shouldn't happen.
                      // but what do I care -- lets skip it.
      fontNames ++;
      continue;
    }

    // the font name is between the second and third dash so:
    // let's find the third dash:

    int dash_two = qfontname.find ('-', dash + 1 , TRUE);

    if (dash == -1) { // No such next dash -- this shouldn't happen.
                      // But what do I care -- lets skip it.
      fontNames ++;
      continue;
    }

    // fish the name of the font info string

    qfontname = qfontname.mid(dash +1, dash_two - dash -1);

    if( !qfontname.contains("open look", TRUE)){
      if(qfontname != "nil"){
	if(fontlist.find(qfontname) == -1)
	  fontlist.inSort(qfontname);
      }
    }


    fontNames ++;

  }

  for(fontlist.first(); fontlist.current(); fontlist.next())
  {	
      QString s;
      s = fontlist.current();
      lstFamily->insertItem(s,-1);
      if (s.stripWhiteSpace() =="times new roman" || s.stripWhiteSpace() =="times")
      	lstFamily->setCurrentItem(lstFamily->count()-1);
  }

  XFreeFontNames(fontNames_copy);
  XCloseDisplay(kde_display);
}

QFont DlgMapTextProperties::getFont(void)
{
	return txtText->font();
}

void DlgMapTextProperties::setFont(QFont font)
{
	unsigned int i;

	txtText->setFont(font);
	
	QString family = font.family();
	family = family.stripWhiteSpace();
	QString size;
	size.sprintf("%d",font.pointSize());	
	
	for (i = 0 ; i<lstFamily->count();i++)
	{
		QString s = lstFamily->text(i);
		if (s == family)
		{
			lstFamily->setCurrentItem(i);
			break;
		}
	}	

	for (i = 0 ; i<lstSize->count();i++)
	{
		QString s = lstSize->text(i);
		if (s == size)
		{
			lstSize->setCurrentItem(i);
			break;
		}
	}	

	chkBold->setChecked(font.bold());
	QCheckBox_2->setChecked(font.italic());
	slotItalicClicked();
	slotBoldClicked();
	lstSize->centerCurrentItem();	
	lstFamily->centerCurrentItem();	
}

void DlgMapTextProperties::setText(QString text)
{
	txtText->setText(text);
}

QString DlgMapTextProperties::getText(void)
{
	return txtText->text();
}

QColor DlgMapTextProperties::getColour(void)
{
	return cmdColour->color();
}

void DlgMapTextProperties::setColour(QColor col)
{
	cmdColour->setColor(col);
}

void DlgMapTextProperties::slotBoldClicked(void)
{
	QFont f = txtText->font();
	f.setBold(chkBold->isChecked());
	txtText->setFont(f);	
}

void DlgMapTextProperties::slotItalicClicked(void)
{
	QFont f = txtText->font();
	f.setItalic(QCheckBox_2->isChecked());
	txtText->setFont(f);	
}

void DlgMapTextProperties::slotSizeSelected(int index)
{
	txtSize->setText(lstSize->text(index));	
}

void DlgMapTextProperties::slotFamilySelected(int index)
{
	QFont f = txtText->font();
	f.setFamily(lstFamily->text(index));
	txtText->setFont(f);
}

void DlgMapTextProperties::slotSizeChanged(const char *size)
{
	QString s = size;
	
	if (s.toInt() > 0)
	{
		QFont f = txtText->font();
		f.setPointSize(s.toInt());
		txtText->setFont(f);
	}
}

void DlgMapTextProperties::slotColourChanged ( const QColor & col)
{
		
}
