/***************************************************************************
                          kboard.h  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBOARD_H
#define KBOARD_H

#include <qwidget.h>
#include <qarray.h>
#include <qlist.h>

#include "ksquare.h"

/**
  *@author Jos Pablo Fernndez
  */

class KBoard : public QWidget  {
   Q_OBJECT
public:
	KBoard(QWidget *parent=0, const char *name=0, int num_rows=0, int num_cols=0,
		QArray<KSquare::Background> background=0,
		QArray<KSquare::State> squares=0,
		int square_size=40, QArray<QImage *> backgrounds=0, QArray<QImage *>  images=0); 	
	~KBoard();
	KSquare *getSquare(int i, int j) ;	
	bool getSelected() ;
	void select(KSquare *square) ;
	void unselect(KSquare *square);
	void tip(KSquare *square) ;
	void untipAll() ;
	KSquare *squareMid(KSquare *square_start, KSquare *square_end) ;
	void move(KSquare *square_start, KSquare *square_end) ;
	KSquare *getSquareSelected() ;

protected slots:
	void processClicks (KSquare::State, KSquare *) ;
signals:
	void sigClick(KSquare::State, KSquare *) ;

private:
	int rows ;
	int cols ;
	
	bool selected ;
	KSquare *square_selected ;
	int row_selected ;
	int col_selected ;
	QList<KSquare> list_tiped ;

 	QArray<KSquare *> squares;
	QArray<QImage *> backgrounds ;
	QArray<QImage *> images ;

	bool game_over ;
};

#endif
