/***************************************************************************
                          kpeggy.h  -  description
                             -------------------
    begin                : jue nov  8 22:42:52 CET 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPEGGY_H
#define KPEGGY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>

#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaction.h>

#include "kboard.h"
#include "peggydata.h"

#define ID_STATUS_MSG 1

/** Hello is the base class of the project */
class KPeggy : public KMainWindow
{
Q_OBJECT
public:
	/** construtor */
	KPeggy(QWidget * widget=0, const char *name=0);
	/** destructor */
	~KPeggy();

public slots:
	void slotNew();
	void slotFileQuit() ;
	void slotViewToolBar() ;
	void slotViewStatusBar() ;
	void slotViewMenuBar() ;
	void slotPreferences() ;
	void slotStatusMsg(const QString &text) ;
	void slotMsg(const QString &text) ;
	void slotClick (KSquare::State state,  KSquare *square) ;
	void slotTip() ;
	void slotDemo() ;
	void slotUndo() ;
	void slotRedo() ;

private:
	KBoard *kboard ;
	PeggyData *I ;
	QArray<QImage *> backgrounds ;
	QArray<QImage *> images ;

	KAction *gameNew  ; 		
	KAction *gameClose  ; 		
	KAction *gameQuit ; 		
	KAction *gameTip ;
	KAction *gameDemo ;
	KToggleAction *viewToolBar ; 		
	KToggleAction *viewStatusBar ; 	
	KToggleAction *viewMenuBar ; 	
	KAction *viewPreferences ;	
	KAction *editUndo ;
	KAction *editRedo ;
};

#endif
