/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGAMEWIDGET_H
#define KGAMEWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

#include <qpoint.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qtimer.h>

class KPuzzleView;
class KPuzzleApp;

class KGameWidget : public QWidget
{
	Q_OBJECT
 public:
	KGameWidget(QWidget *parent,KPuzzleApp* app);
	virtual ~KGameWidget();
// Initialize some things that cannot be done in the constructor
	void initialize(QSize picSize);

// Data
 public:
// Upper left corner of the picture's area that is currently visible
	QPoint& scrollPos() { return _scrollPos; }
// Which of the "moving keys" is pressed?
	char moveKeyPressed() { return _moveKeyPressed; }

 protected:
// Basic piece size
        QSize pieceSize();
// Size of the displayed piece
        QSize pieceSizeDisp();
// Center of the piece currently moved, -1/-1 if there is none
	QPoint piecePos() { return _piecePos; }
// Rectangle of ...
	QRect pieceRect();
// Top-Left corner of ...
        QPoint pieceTopLeft();

	QPoint _scrollPos;
        QPoint _movePos;
	KPuzzleApp* _app;
	QPoint _piecePos;
// Timer for moving the visible area when a "moving key" is pressed
	QTimer* _moveTimer;
	char _moveKeyPressed;
// Is the right mouse key pressed
        bool _rightPressed;

        QPixmap* _backBuffer;

// Implementation
 public:


 protected:
	virtual void paintEvent(QPaintEvent* event);
	virtual void mouseMoveEvent(QMouseEvent* event);
	virtual void mousePressEvent(QMouseEvent* event);
        virtual void mouseReleaseEvent(QMouseEvent* event);
	virtual void leaveEvent(QEvent*);

// Returns the logical position of the piece, i.e. independent from the size
	QPoint calculatePiecePos(QPoint p);

// Widget coordinates <-> Pixmap coordinates (not dependent on the scrollPos)
	QPoint LPtoDP(QPoint pt) { return pt - scrollPos(); }
	QPoint DPtoLP(QPoint pt) { return pt + scrollPos(); }
	QRect LPtoDP(QRect r) { return QRect(LPtoDP(r.topLeft()),LPtoDP(r.bottomRight())); }
	QRect DPtoLP(QRect r) { return QRect(DPtoLP(r.topLeft()),DPtoLP(r.bottomRight())); }

 public slots:
	void slotLeftPress();
	void slotLeftRelease();
	void slotRightPress();
	void slotRightRelease();
	void slotUpPress();
	void slotUpRelease();
	void slotDownPress();
	void slotDownRelease();

	void slotMoveTimer();

	void slotShowAt(QPoint pos);

 signals:
	void sigShowAt(QPoint pos);
};

#endif // KGAMEWIDGET_H
