/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"
#include "piecewidget.h"

#include "kpuzzle.h"
#include "kpuzzleapp.h"

#include <qrect.h>

#include <kapp.h>
#include <kconfig.h>

CPieceWidget::CPieceWidget(QWidget *parent) : QWidget(parent)
{
	_app = NULL;
}

CPieceWidget::~CPieceWidget()
{
}

QPixmap* CPieceWidget::currentPiece() const
{
	return _app->currentPieceTurned();
}

// Where in this widget should the piece be drawn (for centering)
QRect CPieceWidget::getPieceDrawRect() const
{
	QSize sz = _app->pieceSizeDisp();
	QSize own = this->size();
	own -= sz;
	own /= 2;
	QRect rct(own.width(),own.height(),sz.width(),sz.height());
	return rct;

}

void CPieceWidget::paintEvent(QPaintEvent* event)
{
	// The piece is already turned
	bitBlt(this,0,0,currentPiece(),0,0,_app->pieceSizeDisp().width(),
		_app->pieceSizeDisp().height());
}

void CPieceWidget::slotNextClicked()
{
	if (_app->setNextPiece()) update();
}

void CPieceWidget::slotPrevClicked()
{
	if (_app->setPrevPiece()) update();
}

void CPieceWidget::slotTurn1Clicked()
{
	if (kapp->sessionConfig()->readBoolEntry("TurnPiecesAround",
		SV_TURN_PIECES_AROUND))
		_app->turnCW();
	else
		_app->changeLRTurn();
	update();
}

void CPieceWidget::slotTurn2Clicked()
{
	if (kapp->sessionConfig()->readBoolEntry("TurnPiecesAround",
		SV_TURN_PIECES_AROUND))
		_app->turnCCW();
	else
		_app->changeUDTurn();
	update();
}

