/*
 * move.c
 *
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 *
 */

#include "rogue.h"
#include "dun.h"

short m_moves = 0;
boolean jump = 1;
char *you_can_move_again = _T("you can move again");

extern short cur_room, halluc, blind, levitate;
extern short cur_level, max_level;
extern short bear_trap, haste_self, confused;
extern short e_rings, regeneration, auto_search;
extern char hunger_str[];
extern boolean being_held, interrupted, r_teleport;

update_rogue(row, col)
{
	updatech(rogue.row, rogue.col);
	vdungeon[row][col]=get_dungeon_char(row, col);
	addobj(row, col, V_ROGUE);
}

one_move_rogue(dirch, pickup)
short dirch, pickup;
{
	short row, col;
	object *obj;
	char desc[MSGLEN+3];
	short n, status;

	row = rogue.row;
	col = rogue.col;

	if (confused) {
		dirch = gr_dir();
	}
	get_dir_rc(dirch, &row, &col, 1);

	if (!can_move(rogue.row, rogue.col, row, col)) {
		return(MOVE_FAILED);
	}
	if (being_held || bear_trap) {
		if (!(dungeon[row][col] & MONSTER)) {
			if (being_held) {
				message(_i18n("you are being held"), 1);
			} else {
				message(_i18n("you are still stuck in the bear trap"), 0);
				(void) reg_move();
			}
			return(MOVE_FAILED);
		}
	}
	if (r_teleport) {
		if (rand_percent(R_TELE_PERCENT)) {
			tele();
			return(STOPPED_ON_SOMETHING);
		}
	}
	if (dungeon[row][col] & MONSTER) {
		rogue_hit(object_at(&level_monsters, row, col), 0);
		(void) reg_move();
		return(MOVE_FAILED);
	}
	if (dungeon[row][col] & DOOR) {
		if (cur_room == PASSAGE) {
			cur_room = get_room_number(row, col);
			light_up_room(cur_room, row, col);
			updatech(rogue.row, rogue.col);
			wake_room(cur_room, 1, row, col);
		} else {
			light_passage(row, col);
		}
	} else if ((dungeon[rogue.row][rogue.col] & DOOR) &&
		   (dungeon[row][col] & TUNNEL)) {
		light_passage(row, col);
		wake_room(cur_room, 0, rogue.row, rogue.col);
		darken_room(cur_room);
		cur_room = PASSAGE;
	} else if (dungeon[row][col] & TUNNEL) {
			light_passage(row, col);
	} else {
		update_rogue(row, col);
	}
	rogue.row = row;
	rogue.col = col;
	if (dungeon[row][col] & OBJECT) {
		if (levitate && pickup) {
			return(STOPPED_ON_SOMETHING);
		}
		if (pickup && !levitate) {
			if (obj = pick_up(row, col, &status)) {
				get_desc(obj, desc);
				if (obj->what_is == GOLD) {
					free_object(obj);
					goto NOT_IN_PACK;
				}
			} else if (!status) {
				goto MVED;
			} else {
				goto MOVE_ON;
			}
		} else {
			char descbuf[MSGLEN], buf2[MSGLEN];
MOVE_ON:
			obj = object_at(&level_objects, row, col);
			format_str(buf2, "moved onto ${0}", "movedonto", 1,
			    DESCR, 0, "%s");
			get_desc2(obj, descbuf, get_saved_chr());
			snprintf(desc, MSGLEN, buf2, descbuf);
			goto NOT_IN_PACK;
		}
		n = strlen(desc);
		desc[n] = '(';
		desc[n+1] = obj->ichar;
		desc[n+2] = ')';
		desc[n+3] = 0;
NOT_IN_PACK:
		message(desc, 1);
		(void) reg_move();
		return(STOPPED_ON_SOMETHING);
	}
	if (dungeon[row][col] & (DOOR | STAIRS | TRAP)) {
		if ((!levitate) && (dungeon[row][col] & TRAP)) {
			trap_player(row, col);
		}
		(void) reg_move();
		return(STOPPED_ON_SOMETHING);
	}
MVED:	if (reg_move()) {			/* fainted from hunger */
			return(STOPPED_ON_SOMETHING);
	}
	return((confused ? STOPPED_ON_SOMETHING : MOVED));

}

int tunr, tunc;

multiple_move_rogue(dirch)
{

	short row, col;
	short m;

	if (dirch & CMD_RUN)
	{
		dirch &= ~CMD_RUN;
		tunr = tunc = 0;
		do {
			if (dungeon[rogue.row][rogue.col]&TUNNEL)
			{
			    if ((tunr != 0) || (tunc != 0))
			    {
				if ((tunr==-1) && (tunc==-1)) dirch='y';
				if ((tunr==-1) && (tunc== 0)) dirch='k';
				if ((tunr==-1) && (tunc== 1)) dirch='u';
				if ((tunr== 0) && (tunc==-1)) dirch='h';
				if ((tunr== 0) && (tunc== 1)) dirch='l';
				if ((tunr== 1) && (tunc==-1)) dirch='b';
				if ((tunr== 1) && (tunc== 0)) dirch='j';
				if ((tunr== 1) && (tunc== 1)) dirch='n';
			    }
			}
			row = rogue.row;
			col = rogue.col;
			if (((m = one_move_rogue((dirch), 1)) == MOVE_FAILED) ||
				(m == STOPPED_ON_SOMETHING) ||
				interrupted) {
				break;
			}
		} while (!next_to_something(row, col));
		return;
	}
	switch(dirch) {
	case 'H':
	case 'J':
	case 'K':
	case 'L':
	case 'B':
	case 'Y':
	case 'U':
	case 'N':
		while (	(!interrupted) &&
				(one_move_rogue((dirch + 32), 1) == MOVED)) ;
		break;
	}
}

is_passable(row, col)
register row, col;
{
	if ((row < MIN_ROW) || (row > (DROWS - 2)) || (col < 0) ||
		(col > (DCOLS-1))) {
		return(0);
	}
	if (dungeon[row][col] & HIDDEN) {
		return((dungeon[row][col] & TRAP) ? 1 : 0);
	}
	return(dungeon[row][col] & (FLOOR | TUNNEL | DOOR | STAIRS | TRAP));	
}

next_to_something(drow, dcol)
register drow, dcol;
{
	short i, j, i_end, j_end, row, col;
	short pass_count = 0;
	unsigned short s, v;

	tunr = tunc = 0;
	if (confused) {
		return(1);
	}
	if (blind) {
		return(0);
	}
	i_end = (rogue.row < (DROWS-2)) ? 1 : 0;
	j_end = (rogue.col < (DCOLS-1)) ? 1 : 0;
	if ((dungeon[drow][dcol] & DOOR) &&
	    (dungeon[rogue.row][rogue.col] & FLOOR))
	    return(1);

	for (i = ((rogue.row > MIN_ROW) ? -1 : 0); i <= i_end; i++) {
		for (j = ((rogue.col > 0) ? -1 : 0); j <= j_end; j++) {
			if ((i == 0) && (j == 0)) {
				continue;
			}
			if (((rogue.row+i) == drow) && ((rogue.col+j) == dcol)) {
				continue;
			}
			row = rogue.row + i;
			col = rogue.col + j;
			s = dungeon[row][col];
			v = vdungeon[row][col];
			if (s & HIDDEN) {
				continue;
			}
			/* If the rogue used to be right, up, left, down, or right of
			 * row,col, and now isn't, then don't stop */
			if ((v & OBJMASK) || ((v>>FLSH)&~V_DARK) == V_STAIRS) {
				if (((row == drow) || (col == dcol)) &&
					(!((row == rogue.row) || (col == rogue.col)))) {
					continue;
				}
				return(1);
			}
			if (s & TRAP) {
				if (!(s & HIDDEN)) {
					if (((row == drow) || (col == dcol)) &&
						(!((row == rogue.row) || (col == rogue.col)))) {
						continue;
					}
					return(1);
				}
			}
			if ((s & TUNNEL) && can_move(rogue.row, rogue.col, row, col)) {
				if (++pass_count > 1) {
					return(1);
				} else
				{
					tunr = i;
					tunc = j;
				}
			}
			if ((s & DOOR) && ((i == 0) || (j == 0))) {
					return(1);
			}
		}
	}
	return(0);
}

can_move(row1, col1, row2, col2) 
{
	if (!is_passable(row2, col2)) {
		return(0);
	}
	if ((row1 != row2) && (col1 != col2)) {
		if ((dungeon[row1][col1]&DOOR)||(dungeon[row2][col2]&DOOR)) {
			return(0);
		}
		if ((!dungeon[row1][col2]) || (!dungeon[row2][col1])) {
			return(0);
		}
	}	
	return(1);
}

move_onto()
{
  (void) one_move_rogue(direction, 0);
}

boolean
is_direction(c)
{
	return(
		(c == 'h') ||
		(c == 'j') ||
		(c == 'k') ||
		(c == 'l') ||
		(c == 'b') ||
		(c == 'y') ||
		(c == 'u') ||
		(c == 'n') ||
		(c == CANCEL)
		);		
}

boolean
check_hunger(messages_only)
boolean messages_only;
{
	register short i, n;
	static boolean alt = 0;
	boolean fainted = 0;

	if (rogue.moves_left == HUNGRY) {
		(void) strcpy(hunger_str, _T("hungry"));
		message(transl(hunger_str), 1);
		print_stats(STAT_HUNGER);
	}
	if (rogue.moves_left == WEAK) {
		(void) strcpy(hunger_str, _T("weak"));
		message(transl(hunger_str), 1);
		print_stats(STAT_HUNGER);
	}
	if (rogue.moves_left <= FAINT) {
		if (rogue.moves_left == FAINT) {
			(void) strcpy(hunger_str, _T("faint"));
			message(transl(hunger_str), 1);
			print_stats(STAT_HUNGER);
		}
		n = get_rand(0, (FAINT - rogue.moves_left));
		if (n > 0) {
			fainted = 1;
			if (rand_percent(40)) {
				rogue.moves_left++;
			}
			message(_i18n("you faint"), 1);
			for (i = 0; i < n; i++) {
				if (coin_toss()) {
					mv_mons();
				}
			}
			message(transl(you_can_move_again), 1);
		}
	}
	if (messages_only) {
		return(fainted);
	}
	if (rogue.moves_left <= STARVE) {
		killed_by((object *) 0, STARVATION);
	}

	switch(e_rings) {
	/*case -2:
		Subtract 0, i.e. do nothing.
		break;*/
	case -1:
		if (alt = !alt) {
			rogue.moves_left--;
		}
		break;
	case 0:
		rogue.moves_left--;
		break;
	case 1:
		rogue.moves_left--;
		(void) check_hunger(1);
		if (alt = !alt) {
			rogue.moves_left--;
		}
		break;
	case 2:
		rogue.moves_left--;
		(void) check_hunger(1);
		rogue.moves_left--;
		break;
	}	
	return(fainted);
}

boolean
reg_move()
{
	boolean fainted;

	if ((rogue.moves_left <= HUNGRY) || (cur_level >= max_level)) {
		fainted = check_hunger(0);
	} else {
		fainted = 0;
	}

	mv_mons();

	if (++m_moves >= 120) {
		m_moves = 0;
		wanderer();
	}
	if (halluc) {
		if (!(--halluc)) {
			unhallucinate();
		} else {
			hallucinate();
		}
	}
	if (blind) {
		if (!(--blind)) {
			unblind();
		}
	}
	if (confused) {
		if (!(--confused)) {
			unconfuse();
		}
	}
	if (bear_trap) {
		bear_trap--;
	}
	if (levitate) {
		if (!(--levitate)) {
			message(_i18n("you float gently to the ground"), 1);
			if (dungeon[rogue.row][rogue.col] & TRAP) {
				trap_player(rogue.row, rogue.col);
			}
		}
	}
	if (haste_self) {
		if (!(--haste_self)) {
			message(_i18n("you feel yourself slowing down"), 0);
		}
	}
	heal();
	if (auto_search > 0) {
		search(auto_search, auto_search);
	}	
	return(fainted);
}

rest(count)
{
	long i;

	interrupted = 0;

	for (i = 0; i < count; i++) {
		if (interrupted) {
			break;
		}
		(void) reg_move();
	}
	if (i != count)
	{
		char msg[MSGLEN];
		if (i == 1) {
			strncpy(msg, _i18n("you were resting for 1 move"), MSGLEN);
			msg[MSGLEN-1] = 0;
		} else format_str(msg, "you were resting for ${0} moves",
			          "restcnt", 1, LNUMBER, 0, &i);
		message(msg, 0);
	}
}

gr_dir()
{
	short d;

	d = get_rand(1, 8);

	switch(d) {
		case 1:
			d = 'j';
			break;
		case 2:
			d = 'k';
			break;
		case 3:
			d = 'l';
			break;
		case 4:
			d = 'h';
			break;
		case 5:
			d = 'y';
			break;
		case 6:
			d = 'u';
			break;
		case 7:
			d = 'b';
			break;
		case 8:
			d = 'n';
			break;
	}
	return(d);	
}

heal()
{
	static short heal_exp = -1, n, c = 0;
	static boolean alt;

	if (rogue.hp_current == rogue.hp_max) {
		c = 0;
		return;
	}
	if (rogue.exp != heal_exp) {
		heal_exp = rogue.exp;

		switch(heal_exp) {
		case 1:
			n = 20;
			break;
		case 2:
			n = 18;
			break;
		case 3:
			n = 17;
			break;
		case 4:
			n = 14;
			break;
		case 5:
			n = 13;
			break;
		case 6:
			n = 10;
			break;
		case 7:
			n = 9;
			break;
		case 8:
			n = 8;
			break;
		case 9:
			n = 7;
			break;
		case 10:
			n = 4;
			break;
		case 11:
			n = 3;
			break;
		case 12:
		default:
			n = 2;
		}
	}
	if (++c >= n) {
		c = 0;
		rogue.hp_current++;
		if (alt = !alt) {
			rogue.hp_current++;
		}
		if ((rogue.hp_current += regeneration) > rogue.hp_max) {
			rogue.hp_current = rogue.hp_max;
		}
		print_stats(STAT_HP);
	}
}
