#ifndef __prefdialog_h__
#define __prefdialog_h__
#include <qstring.h>
#include <qtabdialog.h>
#include <kconfig.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlist.h>
#include <qslider.h>
#include "providerpref.h"
/* maximum length of a provider name */
#define MAX_LEN 20

class prefDialog : public QTabDialog
{
	Q_OBJECT

	public:
		prefDialog(QWidget* parent=0, const char* name=0,KConfig *conf=0,int maxS=100,int minS=10);
		~prefDialog();
		void changeSize(int);


	protected:
		void resizeEvent( QResizeEvent* );

	private slots:
		void slotOk();
		void slotCancel();
		void slotNew();
		void providerRemoved(int);
		void updateSize(int);

	signals:
		void okPressed(bool);

	private:
		bool providerAddedOrRemoved;
		void getDMConfig(void);
		void setDMConfig(void);

		QVBoxLayout *generalLayout;

		QGroupBox *sizeBox;
		QGridLayout *sizeGrid;
		QSlider *sizeSlider;
		QLabel *sizeLabel;
		QLabel *lpx;
		int maxSize,minSize,size;

		QGroupBox *newButtonBox;
		QPushButton *newButton;

		QList <providerPref> *TabsList;
		QWidget *generalSettings;

		KConfig *DMConf;

		QGroupBox *colorsBox;
		QGridLayout *colorGrid;
			QLabel *lOn;
		QLabel *lOff;
		QLabel *lDial;
		KColorButton *bOn;
		KColorButton *bOff;
		KColorButton *bDial;

		QGroupBox *scaleBox;
		QGridLayout *scaleGrid;
		QLineEdit *lineScale;

		QGroupBox *timerBox;
		QGridLayout *timerGrid;
		QLineEdit *lineTimer;

		QHBoxLayout *scaleTimerLayout;

};



#endif
