#include <kwvdial.h>
#include <kwvdial.moc>

Kwvdial::Kwvdial(QWidget *parent, const char *name)
        : KTMainWindow(name)
                       ,cfg("/etc/wvdial.conf")
	    	       ,dialer(NULL)
                       ,log("KWvDial",WvLog::Info)
		       ,timeonline(0)
		       ,rcv(0)
		       ,tmt(0)
		       ,rate(0)
{

    file_menu = new QPopupMenu( this );
    CHECK_PTR( file_menu );
    file_menu->insertItem("E&xit",qApp,SLOT(quit()),CTRL+Key_Q );

    if ( isKDEWm() )
    {    
    	view_menu = new QPopupMenu(this);
	CHECK_PTR(view_menu);
        view_menu->insertItem("&Hide", this, SLOT(viewiconic()));
    }
    
    connect_menu = new QPopupMenu( this );
    CHECK_PTR(connect_menu);    
    connect(connect_menu, SIGNAL(activated(int)), this, SLOT(wvconnect(int)));
    connect(connect_menu, SIGNAL(aboutToShow()), this, SLOT(fillmenu()));
        
    help_menu = new QPopupMenu();
    help_menu->insertItem("&Help", this, SLOT(invokeHelp()));
    help_menu->insertSeparator();
    help_menu->insertItem("&About", this, SLOT(wvabout()));

    menuBar = new KMenuBar(this, "menubar");
    menuBar->insertItem("&File", file_menu);
    if ( isKDEWm() )
    	menuBar->insertItem("&View", view_menu);
    menuBar->insertItem("&Connect", connect_menu);
    menuBar->insertItem("&Help", help_menu);
    
    setMenu(menuBar);
    
    statusBar = new KStatusBar(this);
    statusBar->message("Offline",0);
    setStatusBar(statusBar);

    timer = new QTimer(this);
    connect(timer,SIGNAL(timeout()),this,SLOT(wvtimer()));
    timer->start(1000,FALSE);

    logview = new KwvdialWidget(this,"MainWidget",cfg);
    setView(logview);
    
    enableStatusBar();

    log("Welcome to KWvDial Version %s\n\n",VERSION);
}

Kwvdial::~Kwvdial()
{
    // If the modem is still connected, hangup before we quit
    if ((dialer != NULL) && (dialer->status() == WvDialer::Online))
    {
	dialer->hangup();
	delete dialer;
    }

    delete file_menu;
    if (view_menu != NULL)
    {
	delete view_menu;
    }
    delete connect_menu;
    delete help_menu;
    delete statusBar;
    delete menuBar;
}

void Kwvdial::invokeHelp()
{
    kapp->invokeHTMLHelp("kwvdial/kwvdial.html", "");
}

void Kwvdial::wvabout()
{
    QMessageBox::information(this,"KWvDial " VERSION,
			     "\nKWvDial Version "
			     VERSION "\n\n"
			     "Written by:\n\tPatrick Patterson\n"
			     "\tppatters@cnss.ca\n and\n"
			     "\tAvery Pennarun\n"
			     "\tapenwarr@worldvisions.ca\n"); 
}

void Kwvdial::viewiconic()
{
    log("Docking....\n");
    hide();

    // Create the KwvdialDock Widget and pass this object into it
    KWVDock = new KwvdialDock("KWVDock",this);
    KWVDock->show();
}

void Kwvdial::fillmenu()
{    
    connect_menu->clear();
    
    WvConf::Iter i(cfg);
    
    for(i.rewind();i.next();)
	connect_menu->insertItem((QString &)i().name, -1);
    connect_menu->insertSeparator();
    connect_menu->insertItem("&Disconnect", this, SLOT(wvdisconnect()));
}

void Kwvdial::wvconnect(int id)
{
    QString *buf;

    if (dialer==NULL)
    {
	if (id >= 0)
	{
	    sections = new WvStringList;
	    sections->append(new WvString(connect_menu->text(id)),true);

	    buf = new QString(cfg.fuzzy_get(*sections,"Rate","")); // Read in the Rate
	    buf->remove(buf->length()-3,1);              // Remove the decimal place
	    rate = buf->toInt();                         // Convert to Int

	    dialer= new WvDialer(cfg,sections);
	    dialer->dial();
	    statusBar->message("Dialing....");
	} else {
	   log("*** Error: Invalid Profile ID"); // We should never get here
	}
    } else {
	log("*** In Use, Please disconnect first\n");
    }
}

void Kwvdial::wvdisconnect()
{
    int hours,minutes,seconds;
    char statustext[1024];
    char costtext[1024];
    int dollars,cents;
    int total;
    
    if (dialer !=NULL)
    {
	gettraffic();
	dialer->hangup();
	logview->statsoff();
	delete dialer;
	dialer = NULL;
	statusBar->message("Offline");
	if ( (timeonline/60) > 0)
	{
	    if ( (timeonline/3600) > 0)
	    {   
		hours = (timeonline / 3600) ;
		minutes = (timeonline % 3600) / 60 ;
		seconds = (timeonline % 3600) % 60 ;
	    } else {
		hours = 0;
		minutes = timeonline / 60;
		seconds = timeonline % 60;
	    }
	} else {
	    seconds = timeonline;
	    minutes = 0;
	    hours = 0;
	}
	if (timeonline > 0)
        {
		if (rate > 0)
		{
			total=((timeonline/60) * rate) + ((timeonline%60) * (rate/60));
			dollars = total / 100;
			cents = total % 100;
			sprintf(costtext,"For a cost of: %0d.%02d",dollars,cents);
		}
		sprintf(statustext,"Online for: %d:%02d:%02d",hours,minutes,seconds);
		log("%s\n",statustext);
		if (rate > 0)
			log("%s\n",costtext);
		log("Bytes In:%i \n",rcv);
		log("Bytes Out:%i \n",tmt);
        	timeonline = 0;
	}
    } else {
	log("Not Connected...\n");
    }
}

void Kwvdial::getPPPIPaddr()
{
	int sock;
	struct ifreq *ifr;

	pppaddr = (in_addr *)malloc(sizeof(in_addr));
	ifr = (struct ifreq *)malloc(sizeof(ifreq));
	sock = socket(AF_INET, SOCK_STREAM, 0);
	strncpy (ifr->ifr_name, "ppp0", IFNAMSIZ-1);
	ifr->ifr_name[IFNAMSIZ-1] = 0;
	ifr->ifr_addr.sa_family = AF_INET;
	ioctl(sock, SIOCGIFADDR, ifr);
	memcpy(pppaddr,ifr->ifr_addr.sa_data,sizeof(pppaddr));
	free(ifr);
}

void Kwvdial::gettraffic()
{
    FILE *netproc;
    char bf[256],prefix[50];
    
    netproc = fopen("/proc/net/dev","r");
    if (netproc)
    {
	do 
	{
	    fgets(bf, 254, netproc);
	    sscanf(bf, "%s", prefix);
	    if (!strcmp(prefix, "ppp0:"))
	    {
		sscanf(bf,"%s%li%*i%*i%*i%*i%li",prefix,&rcv,&tmt);	
	    }

	} while (!feof(netproc)); 
	if ( (rcv > 0) || (tmt > 0) )
	{
	    log("Bytes In:%i\n",rcv);
	    log("Bytes Out:%i\n",tmt);
	}
	fclose(netproc);
    } else {
	log("Critical Error: Can't open /proc/net/dev\n");
    }
}

void Kwvdial::wvtimer()
{
    int hours = 0;
    int minutes = 0;
    int seconds = 0;
    char statustext[1024];
			
    if (dialer != NULL && dialer->isok() && (dialer->status() != WvDialer::Online))
    {	// If it is dialling... have it keep dialling....
	if (dialer->select(2))
	    dialer->callback();
    } else {
//	if ( dialer != NULL && dialer->status() == WvDialer::Online)
//	{ log("Dialer Experienced an undefined problem\n");
//	  log("Check your modem or telephone connection\n");
//   	  wvdisconnect();
//	}
    }
    if (dialer != NULL && dialer->status() == WvDialer::Online)
    {
	// If it is online - start or advance the timer - 
        // eventually do something with QTime
	if (timeonline == 0)
	{
	    // If it just stopped dialling then initialize the timer
            // then get the IP Address, and print the status on the screen
	    connecttime = time((time_t *)0);
	    timeonline++;
	    statusBar->message("Online");
	    log("Connected....\n");
//	    getPPPIPaddr();
//	    log("IP Address of PPP Interface: %s\n",inet_ntoa(*pppaddr));
//	    free(pppaddr);
	} else {
	    // Weve been online for at least a second... 
            // so set the counters to the length of time online 
	    // REVISIT THIS - I think it could be optimized.... 
	    currenttime = time((time_t *)0);
	    timeonline = (int)difftime(currenttime,connecttime);
	    logview->update(timeonline);
	    if ( (timeonline/60) > 0)
	    {
		if ( (timeonline/360) > 0)
		{   
		    hours = (timeonline / 360) ;
		    minutes = (timeonline % 360) / 60 ;
		    seconds = (timeonline % 360) % 60 ;
		} else {
		    hours = 0;
		    minutes = timeonline / 60;
		    seconds = timeonline % 60;
		}
	    } else {
		seconds = timeonline;
		minutes = 0;
		hours = 0;
	    }
	    sprintf(statustext,"Online for: %d:%02d:%02d",hours,minutes,seconds);
	    statusBar->message(statustext);
	}
    }
}

bool Kwvdial::isKDEWm()
{
	// check for "KWM_RUNNING" XInternAtom of Root window to tell if KDEWm
	// is running - Not sure how to do this :-<
	// looks like KWM_COMMAND is what I will have to check for in KDE2
	// get the root_window Pointer with qt_xrootwin()
//	if ( KWM::isKWMInitialized() )
		return true;
//	else
//		return false;
}
