/***************************************************************************
                          kexdatasource.h  -  description
                             -------------------
    begin                : Mon Mar 4 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEXDATASOURCE_H
#define KEXDATASOURCE_H

#include <qobject.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qstringlist.h>
#include <qlist.h>
#include <qmap.h>
#include <qpixmap.h>

#include <kio/job.h>
/**
  *@author Tero Favorin
  */

typedef double Rate;
enum confidence{None,Conversion,Reliable,Calculated,CrossConversion,Unreliable};
enum status{Ready,Transfering,Error};

class KIO::TransferJob;
class QStringList;
class QTextStream;

class KExData {
public:
	KExData() {rate=0;date=QDate();confidence=None;}
	KExData(Rate r, QDate d, int c) {rate=r;date=d;confidence=c;}
Rate rate;
QDate date;
int confidence;
};

typedef QMap<QString,QString> CurrencyNames;
typedef QMap<QString,KExData> ExData;

class KExDataSource : public QObject {
Q_OBJECT
public: 
	KExDataSource(QWidget *w);
	virtual ~KExDataSource();
	/** Get rate between base and target currencies */
	const KExData getRate(QString target,QString base);
	/** Set calculation precision */
	void setPrecision(int p) {precision=p;}
	/** Convert from target currency to base currency */
	double convert(QString target,QString base, double amount);
	/** Get currency name from the code. */
	QString getCurrencyName(QString code);
	/** Return list of available currency codes. */
	QStringList getCurrencies(bool oldeuro);
	/** Get flag ot the country for the currency. */
	QPixmap getFlag(QString code);
	/** Get currency code from the list */
	static QString getCode(QStringList list, int pos);
	/** Refresh exchange rates from the data source.
  	Implementing class must create a KTransferJob then call transferData() and exit.
		After data transfer is finished, readData() will be called.
		Full sequence is refresh()->transferData()->readData()->storeData().
	*/
	virtual void refresh()=0;
	/** Data source source info  */
	virtual const QString source()=0;
	/** Data source source url  */
	virtual const QString sourceURL()=0;
	/** Data source copyright info */
	virtual const QString copyright()=0;

signals:
	/** Status message about the data transfer */
	void status(int type, const QString &);
	/* Emitted when data transfer has completed */
	void dataReady();

protected:
	/** Add currency to available currencies list. */
	void addCurrency(QString code);
	/** Data currency exchange rate */
	void addRate(QString target, QString base, Rate rate, QDate date, int confidence);
	/** Parse QDate from YYYY-MM-DD */
	QDate parseDate(QString str, QChar sep);
	/** Read data retrieved from the data source. */
	void transferData(KIO::TransferJob *j);
	/** Read data retrieved from the data source. */
	virtual int readData(QTextStream s)=0;
	/** Store data to XML file.
  	Implementing subclass should call this method after reading data.
	*/
	void storeData();

private slots:
	void slotResult( KIO::Job * );
	void slotData ( KIO::Job *, const QByteArray &);
	void slotMessage ( KIO::Job *, const QString & );
private:
	/** Get rate to USD. */
	KExData toUSD(QString code);
	/** Get Exchange rate key for ExData. */
	QString getKey(QString target, QString base);
	/** Round doubles. */
	Rate round(Rate doValue, int nPrecision);
	/** Read data from XML file. */
	void readData();
	/** Display widget */
	QWidget *parent;
	/** Precision */
	int precision;
	/** Currency code & name pairs. */
	CurrencyNames names;	
	/** List of available currencies. */
	QStringList list;
	/** List of old native currencies that have switched to Euro. */
	QStringList eurolist;
	/** Exchange rates data. */
	ExData data;
	/** Data received from the data source */
	QByteArray *datain;
	/** Stream for writing to datain */
	QDataStream *streamin;
	/** Default (empty) pixmap for flags */
	QPixmap defaultFlag;
};

#endif
