#ifndef __MAINWCLASS
#define __MAINWCLASS

#include <kmainwindow.h>
class KApplication;
class KToolBar;
class KMenuBar;

class QObject;
class QMouseEvent;
class QPaintEvent;
class QPopupMenu;
class QSlider;

class NetWidget;
class XDeviceNet;
class ClientW;
class SimW;

#include <qstring.h>

//************ constants ***************
// 500..599 reserved for netdev!!
// 1000..1999 reserved for device!!

// file operations
#define ID_OPEN		2001
#define ID_SAVE		2002
#define ID_SAVE_AS	2003
#define ID_NEW		2004
#define ID_PRINT	2005
#define ID_EXIT		2006

// edit operations
#define ID_COPY		2100
#define ID_PASTE	2101
#define ID_CUT		2102

// logic
#define ID_DRAW		2200
#define ID_UP		2201
#define ID_SEL		2202

// simulation
#define ID_SIM_SHOW	2300
#define ID_SIM_EQU	2301

// options
#define ID_GLOBAL	2400
#define ID_TOOL_VISIBLE	2401

//************ class *************
class MainWidget : public KMainWindow
{	Q_OBJECT
public:
	MainWidget(KApplication *, char *file=(char *)NULL);
	~MainWidget();

	static QString PATH;
	static QString TBPATH;

public slots:
	void menuCallback(int);
	void modeDraw();
	void modeSel();
	void netChange(int);
	void netDelete(XDeviceNet *);
	void newWidget(XDeviceNet *);
	void repaintClients();
	void simWidgetHidden();
	void clientHidden(ClientW *);
	void simTimeSliderChanged(int);

signals:
	void idChange(int, int);

private:
	static void setPATH(KApplication *);
	static const int MAXCLIENTS = 100;

	void readConfig();
	void writeConfig();

	void mousePressEvent( QMouseEvent * );
	void mouseReleaseEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void paintEvent(QPaintEvent *);
	void setWidgets();
	void initToolbar();
	void setToolbar();
	void initMenubar();
	void turnAllCheckButton(int);
	void dialogSim();
	void dialogGlobal();
	void killClients();
	void devChange(int);
	void simMode(int);
	NetWidget * getActive();

	KToolBar *toolbar;
	KMenuBar *menubar;
	QPopupMenu *pm_file;
	QPopupMenu *pm_edit;
	QPopupMenu *pm_logic;
	QPopupMenu *pm_sim;
	QPopupMenu *pm_options;
	QPopupMenu *pm_help;
	QSlider *speed_slider;

	ClientW *clientW[MAXCLIENTS];
	NetWidget *main_netwidget;
	SimW *simW;
	int simw;
	int tool_visible;

	KConfig *kconf;

	QString filename;
};
#endif
