/************************************/
/* widget methods for DevProp       */
/*                                  */
/* device propperties dialog        */
/*                                  */
/* Andreas Rostin                   */
/* 13.11.98                         */
/************************************/
#include <klineedit.h>

#include <qwidget.h>
#include <qmessagebox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qvalidator.h>

#include <klogic.h>
#include <netw.h>
#include <xnet.h>
#include <xdevice.h>
#include <device.h>
#include <devw.h>
#include <dlgEqu.h>

#include <propDev.h>
#include "propDev.moc"

DevProp::DevProp(QWidget *parent, const char *name, NetWidget *_netw, XDeviceNet *_dnet, XDevice *_dev)
	: QDialog(parent, name, TRUE, WStyle_DialogBorder)
{
    // object to modify in this dialog:
    dev = _dev;
    netw = _netw;
    dnet = _dnet;

    osize = dev->size();
    omaster = dev->hasMaster();
    oclock = dev->clock();

    label0 = new QLabel(this, "Name_widget");
    label0->setGeometry(30, 10, 43, 20);
    label0->setText(klocale->translate("Name"));
    devname = new KLineEdit(this, "devname_widget");
    devname->setEnabled(TRUE);

    label1 = new QLabel(this, "Delay_widget");
    label1->setGeometry(30, 40, 43, 20);
    label1->setText(klocale->translate("Delay"));
    delay = new KLineEdit(this);
    QIntValidator *vDelay = new QIntValidator(delay);
    delay->setValidator(vDelay);
    delay->setGeometry(80, 40, 40, 20);

    cb_display_name = new QCheckBox(klocale->translate("display name"), this);
    cb_display_name->setGeometry(200, 40, 100, 20);
    if (dev->textDisplayed()) cb_display_name->setChecked(TRUE);
    else cb_display_name->setChecked(FALSE);

    label2 = new QLabel(this, "Size_widget");
    label2->setGeometry(35, 70, 32, 20);
    label2->setText(klocale->translate("Size"));
    size = new KLineEdit(this);
    QIntValidator *vSize = new QIntValidator(size);
    size->setValidator(vSize);
    size->setGeometry(80, 70, 40, 20);
    if (!dev->sizeChangeable())
	size->setEnabled(FALSE);

    label5 = new QLabel(this, "Inverter_widget");
    label5->setGeometry(190, 92, 100, 15);
    label5->setText(klocale->translate("Inverter Setting"));
    devw = new InverterWidget(this, name, dev);
    devw->setGeometry(190, 110, 110, 195);

    bg_undef = new QButtonGroup(klocale->translate("Undefined value"), this);
    bg_undef->setGeometry(25, 102, 150, 60);
    undef[0] = new QRadioButton(klocale->translate("Low"), bg_undef);
    undef[0]->setGeometry(30, 16, 100, 20);
    undef[1] = new QRadioButton(klocale->translate("High"), bg_undef);
    undef[1]->setGeometry(30, 36, 100, 20);
    if (dev->undef()) {
    	undef[1]->setChecked(TRUE);
	curr_undef = 1;
    } else {
    	undef[0]->setChecked(TRUE);
        curr_undef = 0;
    }
    bg_undef->insert(undef[0], 0);
    bg_undef->insert(undef[1], 1);

    if (dev->type() == Device::fLEDred ||
	dev->type() == Device::fLEDblue ||
	dev->type() == Device::fLEDgreen ||
	dev->type() == Device::fLEDyellow) {
	bg_invert = (QButtonGroup *)NULL;
	invert[0] = (QRadioButton *)NULL;
	invert[1] = (QRadioButton *)NULL;
	bg_led = new QButtonGroup(klocale->translate("LED Color"), this);
	bg_led->setGeometry(25, 175, 150, 100);
	led_red = new QRadioButton(klocale->translate("red"), bg_led);
	led_red->setGeometry(30, 16, 100, 20);
	led_blue = new QRadioButton(klocale->translate("blue"), bg_led);
	led_blue->setGeometry(30, 36, 100, 20);
	led_green = new QRadioButton(klocale->translate("green"), bg_led);
	led_green->setGeometry(30, 56, 100, 20);
	led_yellow = new QRadioButton(klocale->translate("yellow"), bg_led);
	led_yellow->setGeometry(30, 76, 100, 20);
	switch(dev->type()) {
	case Device::fLEDred:
		led_red->setChecked(TRUE);
		break;
	case Device::fLEDblue:
		led_blue->setChecked(TRUE);
		break;
	case Device::fLEDgreen:
		led_green->setChecked(TRUE);
		break;
	case Device::fLEDyellow:
		led_yellow->setChecked(TRUE);
		break;
	}
	connect(bg_led, SIGNAL(clicked(int)), this, SLOT(setLEDColor(int)));
    } else {
	bg_led = (QButtonGroup *)NULL;
	led_red = (QRadioButton *)NULL;
	led_blue = (QRadioButton *)NULL;
	led_green = (QRadioButton *)NULL;
	led_yellow = (QRadioButton *)NULL;
	bg_invert = new QButtonGroup(klocale->translate("Output always inverted"), this);
	bg_invert->setGeometry(25, 175, 150, 60);
	invert[0] = new QRadioButton(klocale->translate("Not inverted"), bg_invert);
	invert[0]->setGeometry(30,16, 100, 20);
	invert[1] = new QRadioButton(klocale->translate("Inverted"), bg_invert);
	invert[1]->setGeometry(30,36, 100, 20);
	if (dev->isInverted()) invert[1]->setChecked(TRUE);
	else invert[0]->setChecked(TRUE);
	bg_invert->insert(invert[0], 0);
	bg_invert->insert(invert[1], 1);
	if (dev->maxO() == 0) {
		bg_invert->setEnabled(FALSE);
		invert[1]->setEnabled(FALSE);
		invert[0]->setEnabled(FALSE);
	}
	connect(bg_invert, SIGNAL(clicked(int)), this, SLOT(setInverted(int)));
    }
    if (dev->isInverted()) curr_invert = 1;
    else curr_invert = 0;

    if (dev->type() == Device::fEQU) {
	bEQU = new QPushButton(this, "bEQU_widget");
	bEQU->setText(klocale->translate("Equation Editor"));
	bEQU->setGeometry(25, 250, 150, 25);
	connect(bEQU, SIGNAL(clicked()), this, SLOT(showDeviceEquations()));
    }

    bg_clock = new QButtonGroup(klocale->translate("Clock Behaviour"), this);
    bg_clock->setGeometry(315, 102, 150, 120);
    clock[0] = new QRadioButton(klocale->translate("Rising edge"), bg_clock);
    clock[0]->setGeometry(30, 16, 100, 20);
    clock[1] = new QRadioButton(klocale->translate("Falling edge"), bg_clock);
    clock[1]->setGeometry(30,36, 100, 20);
    clock[2] = new QRadioButton(klocale->translate("High value"), bg_clock);
    clock[2]->setGeometry(30,56, 100, 20);
    clock[3] = new QRadioButton(klocale->translate("Low value"), bg_clock);
    clock[3]->setGeometry(30,76, 100, 20);
    clock[4] = new QRadioButton(klocale->translate("Disable"), bg_clock);
    clock[4]->setGeometry(30,96, 100, 20);
    clock[dev->clock()]->setChecked(TRUE);
    curr_clock = dev->clock();
    bg_clock->insert(clock[0], 0);
    bg_clock->insert(clock[1], 1);
    bg_clock->insert(clock[2], 2);
    bg_clock->insert(clock[3], 3);
    bg_clock->insert(clock[4], 4);
    if (!dev->hasClock()) {
	bg_clock->setEnabled(FALSE);
	clock[0]->setEnabled(FALSE);
	clock[1]->setEnabled(FALSE);
	clock[2]->setEnabled(FALSE);
	clock[3]->setEnabled(FALSE);
    }
    if (dev->type() != XDevice::fRS) clock[4]->setEnabled(FALSE);
    if (dev->hasMaster()) clock[4]->setEnabled(FALSE);
    if (!dev->hasMaster()) {
	clock[0]->setEnabled(FALSE);
    	clock[1]->setEnabled(FALSE);
    }

    bg_master = new QButtonGroup(klocale->translate("Master FF"), this);
    bg_master->setGeometry(315, 232, 150, 60);
    master[0] = new QRadioButton(klocale->translate("Disabled"), bg_master);
    master[0]->setGeometry(30, 16, 70, 20);
    master[1] = new QRadioButton(klocale->translate("Enabled"), bg_master);
    master[1]->setGeometry(30, 36, 70, 20);
    master[dev->hasMaster()]->setChecked(TRUE);
    if (!dev->hasClock() || dev->type() == XDevice::fJK) {
	bg_master->setEnabled(FALSE);
	master[0]->setEnabled(FALSE);
	master[1]->setEnabled(FALSE);
    }

    bOK = new QPushButton(this, "bOK_widget");
    bOK->setDefault(true);
    bOK->setText(klocale->translate("OK"));

    bCancel = new QPushButton(this, "bCancel_widget");
    bCancel->setText(klocale->translate(klocale->translate("Cancel")));

    size->setMaxLength(2);
    delay->setMaxLength(4);
    devname->setMaxLength(80);

    if (!dev->hasClock()) {
	    bOK->setGeometry(80, 325, 70, 25);
	    bCancel->setGeometry(170, 325, 70, 25);
            devname->setGeometry(80, 10, 215, 20);
	    setFixedSize(315, 360);
    } else {
	    bOK->setGeometry(165, 325, 70, 25);
	    bCancel->setGeometry(255, 325, 70, 25);
            devname->setGeometry(80, 10, 385, 20);
	    setFixedSize(490, 360);
    }

    setCaption(name);
    devname->setText(dev->getText());
    QString value;
    delay->setText(value.setNum(dev->delay()));
    size->setText(value.setNum(dev->size()));

    connect(size, SIGNAL(textChanged(const QString &)), this, SLOT(setSize(const QString &)));
    connect(bg_undef, SIGNAL(clicked(int)), this, SLOT(setUndefined(int)));
    connect(bg_clock, SIGNAL(clicked(int)), this, SLOT(setClock(int)));
    connect(bg_master, SIGNAL(clicked(int)), this, SLOT(setMaster(int)));
    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

void DevProp::done(int r)
{	int flag;
	QString value;
	int ivalue;

	if (r == Accepted) {
		// set new name
		dnet->setText(dev->getID(), (char *)(const char *)devname->text());

		// delay
		value = delay->text();
		ivalue = value.toInt();
		if (ivalue != dev->delay()) flag = 1;
		else flag = 0;
		if (ivalue < XDevice::MINDELAY)
			ivalue = XDevice::MINDELAY;
		if (ivalue > XDevice::MAXDELAY)
			ivalue = XDevice::MAXDELAY;
		dev->setDelay(ivalue);
		// signal should go to NetWidget::delayChanged() ... XDeviceNet::calcDelay()
		if (flag) emit delayChange();

		// size set by signal

		// switches..
		dev->setInverted(curr_invert);
		dev->setUndef(curr_undef);
		dev->setClock(curr_clock);

		// display the device name
		if (cb_display_name->isChecked()) dev->displayText(1);
		else dev->displayText(0);

		netw->repaint(TRUE);

	} else {
		if (dev->size() != osize) {
			setSize(osize);
		}
		if (dev->hasMaster() != omaster) {
			setMaster(omaster);
		}
		if (dev->clock() != oclock) {
			setClock(oclock);
		}
	}
	QDialog::done(r);
}

void DevProp::showDeviceEquations()
{
	DlgEqu * equation_dialog = new DlgEqu(this, klocale->translate("Device Equation Editor"), dev);
	equation_dialog->show();
	delete equation_dialog;
}

void DevProp::setInverted(int invert)
{	curr_invert = invert;
}

void DevProp::setLEDColor(int color)
{
	switch(color) {
		case 0:
			dev->changeLEDType(Device::fLEDred);
			break;
		case 1:
			dev->changeLEDType(Device::fLEDblue);
			break;
		case 2:
			dev->changeLEDType(Device::fLEDgreen);
			break;
		case 3:
			dev->changeLEDType(Device::fLEDyellow);
			break;
	}
}

void DevProp::setUndefined(int undef)
{	curr_undef = undef;
}

void DevProp::setClock(int clk)
{
	curr_clock = clk;
	dev->setClock(clk);
	devw->setInputButtons();
	devw->repaint(TRUE);
}

void DevProp::setMaster(int m)
{
	dev->setMaster(m);

	if (dev->hasMaster()) {
		clock[0]->setEnabled(TRUE);
		clock[1]->setEnabled(TRUE);
		clock[4]->setEnabled(FALSE);
		if (curr_clock == CLK_NONE) {
			clock[1]->setChecked(TRUE);
			curr_clock = CLK_FALLING_EDGE;
			dev->setClock(curr_clock);
			devw->setInputButtons();
		}
	} else {
		clock[0]->setEnabled(FALSE);
		if (curr_clock == CLK_RISING_EDGE) {
			clock[2]->setChecked(TRUE);
			curr_clock = CLK_HIGH_VALUE;
			dev->setClock(curr_clock);
		}
		clock[1]->setEnabled(FALSE);
		if (curr_clock == CLK_FALLING_EDGE) {
			clock[3]->setChecked(TRUE);
			curr_clock = CLK_LOW_VALUE;
			dev->setClock(curr_clock);
		}
		if (dev->type() == XDevice::fRS) clock[4]->setEnabled(TRUE);
	}
        dev->setImage();
	devw->repaint(TRUE);
}

void DevProp::setSize(const QString& value)
{
	setSize(value.toInt());
}

void DevProp::setSize(int isize)
{
	if (isize < XDevice::MINSIZE)
		isize = XDevice::MINSIZE;
	if (isize > XDevice::MAXSIZE)
		isize = XDevice::MAXSIZE;
	dev->setSize(isize);
	dev->setImage();
	devw->repaint(TRUE);
}

