/*************************************************/
/* methods for class XDevice                     */
/*                                               */
/* visible Device                                */
/*                                               */
/* Andreas Rostin                                */
/* 15.03.99                                      */
/*************************************************/
#include <qpainter.h>

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <xdevice.h>
#include <xwire.h>
#include <mainw.h>
#include <klogic.h>
#include <opStack.h>
#include <value.h>

/***************************************************/
/* static methods of XDevice class                 */
/***************************************************/
int XDevice::STATdef_size = 4;
int XDevice::STATdef_inverted = 0;
int XDevice::STATdisplay_name = 0;
int XDevice::pix_loaded = 0;
QPixmap *XDevice::pxPOS = (QPixmap *)NULL;
QPixmap *XDevice::pxNEG = (QPixmap *)NULL;
QPixmap *XDevice::pxRS = (QPixmap *)NULL;
QPixmap *XDevice::pxRSC = (QPixmap *)NULL;
QPixmap *XDevice::pxRSCMF = (QPixmap *)NULL;
QPixmap *XDevice::pxRSCM = (QPixmap *)NULL;
QPixmap *XDevice::pxDM = (QPixmap *)NULL;
QPixmap *XDevice::pxD = (QPixmap *)NULL;
QPixmap *XDevice::pxJKF = (QPixmap *)NULL;
QPixmap *XDevice::pxJK = (QPixmap *)NULL;
QPixmap *XDevice::pxOUT = (QPixmap *)NULL;
QPixmap *XDevice::pxIN = (QPixmap *)NULL;
QPixmap *XDevice::pxLED0red = (QPixmap *)NULL;
QPixmap *XDevice::pxLED1red = (QPixmap *)NULL;
QPixmap *XDevice::pxLED0blue = (QPixmap *)NULL;
QPixmap *XDevice::pxLED1blue = (QPixmap *)NULL;
QPixmap *XDevice::pxLED0green = (QPixmap *)NULL;
QPixmap *XDevice::pxLED1green = (QPixmap *)NULL;
QPixmap *XDevice::pxLED0yellow = (QPixmap *)NULL;
QPixmap *XDevice::pxLED1yellow = (QPixmap *)NULL;
QPixmap *XDevice::pxSSB = (QPixmap *)NULL;
QPixmap **XDevice::pxSS = (QPixmap **)NULL;
QPixmap *XDevice::pxSWI0 = (QPixmap *)NULL;
QPixmap *XDevice::pxSWI1 = (QPixmap *)NULL;
QPixmap *XDevice::PTOPL = (QPixmap *)NULL;
QPixmap *XDevice::PMIDL = (QPixmap *)NULL;
QPixmap *XDevice::PBOTL = (QPixmap *)NULL;
QPixmap *XDevice::PTOP = (QPixmap *)NULL;
QPixmap *XDevice::PMID = (QPixmap *)NULL;
QPixmap *XDevice::PBOT = (QPixmap *)NULL;
QPixmap *XDevice::syAND = (QPixmap *)NULL;
QPixmap *XDevice::syOR = (QPixmap *)NULL;
QPixmap *XDevice::syXOR = (QPixmap *)NULL;
QPixmap *XDevice::syINV = (QPixmap *)NULL;
QPixmap *XDevice::syOSZ = (QPixmap *)NULL;
QPixmap *XDevice::syNET = (QPixmap *)NULL;
QPixmap *XDevice::sySS = (QPixmap *)NULL;
QPixmap *XDevice::syMONOFLOP = (QPixmap *)NULL;

// static method
int XDevice::defSize()
{	return STATdef_size;
}

// static method
void XDevice::setDefSize(int newi)
{	if (newi > MAXSIZE) STATdef_size = MAXSIZE;
	else if (newi < MINSIZE) STATdef_size = MINSIZE;
	else STATdef_size = newi;
}

// static method
int XDevice::isDefInverted()
{	return STATdef_inverted;
}

// static method
void XDevice::setDefInverted(int newi)
{	if (newi >= 1) STATdef_inverted = 1;
	else STATdef_inverted = 0;
}

// static method
void XDevice::displayTextGlobal(int flag)
{
	if (flag) 
		XDevice::STATdisplay_name = 1;
	else
		XDevice::STATdisplay_name = 0;
}

// static method
int XDevice::textDisplayedGlobal()
{
	return XDevice::STATdisplay_name;
}

// static method
void XDevice::loadPix()
{	QString val;
	int __i;

	pxPOS = new QPixmap;
	pxNEG = new QPixmap;
	pxRS = new QPixmap;
	pxRSC = new QPixmap;
	pxRSCMF = new QPixmap;
	pxRSCM = new QPixmap;
	pxDM = new QPixmap;
	pxD = new QPixmap;
	pxJKF = new QPixmap;
	pxJK = new QPixmap;
	pxOUT = new QPixmap;
	pxIN = new QPixmap;
	pxLED0red = new QPixmap;
	pxLED1red = new QPixmap;
	pxLED0blue = new QPixmap;
	pxLED1blue = new QPixmap;
	pxLED0green = new QPixmap;
	pxLED1green = new QPixmap;
	pxLED0yellow = new QPixmap;
	pxLED1yellow = new QPixmap;
	pxSSB = new QPixmap;
	pxSS = (QPixmap **)malloc(sizeof(QPixmap *) * 16);
	for (__i=0;__i < 16;__i++) {
		pxSS[__i] = new QPixmap;
	}
	pxSWI0 = new QPixmap;
	pxSWI1 = new QPixmap;
	PTOPL = new QPixmap;
	PMIDL = new QPixmap;
	PBOTL = new QPixmap;
	PTOP = new QPixmap;
	PMID = new QPixmap;
	PBOT = new QPixmap;
	syAND = new QPixmap;
	syOR = new QPixmap;
	syXOR = new QPixmap;
	syINV = new QPixmap;
	syOSZ = new QPixmap;
	syNET = new QPixmap;
	sySS = new QPixmap;
	syMONOFLOP = new QPixmap;

	pxPOS->load(MainWidget::PATH + "pxPOS.xpm");
	pxNEG->load(MainWidget::PATH + "pxNEG.xpm");
	pxRS->load(MainWidget::PATH + "pxRS.xpm");
	pxRSC->load(MainWidget::PATH + "pxRSC.xpm");
	pxRSCMF->load(MainWidget::PATH + "pxRSCMF.xpm");
	pxRSCM->load(MainWidget::PATH + "pxRSCM.xpm");
	pxDM->load(MainWidget::PATH + "pxDM.xpm");
	pxD->load(MainWidget::PATH + "pxD.xpm");
	pxJKF->load(MainWidget::PATH + "pxJKF.xpm");
	pxJK->load(MainWidget::PATH + "pxJK.xpm");
	pxOUT->load(MainWidget::PATH + "pxOUT.xpm");
	pxIN->load(MainWidget::PATH + "pxIN.xpm");
	pxLED0red->load(MainWidget::PATH + "pxLED0red.xpm");
	pxLED1red->load(MainWidget::PATH + "pxLED1red.xpm");
	pxLED0green->load(MainWidget::PATH + "pxLED0green.xpm");
	pxLED1green->load(MainWidget::PATH + "pxLED1green.xpm");
	pxLED0blue->load(MainWidget::PATH + "pxLED0blue.xpm");
	pxLED1blue->load(MainWidget::PATH + "pxLED1blue.xpm");
	pxLED0yellow->load(MainWidget::PATH + "pxLED0yellow.xpm");
	pxLED1yellow->load(MainWidget::PATH + "pxLED1yellow.xpm");
	pxSSB->load(MainWidget::PATH + "pxSS.xpm");
	for (__i=0;__i < 16;__i++) {
		val.sprintf("%d", __i);
		pxSS[__i]->load(MainWidget::PATH + "pxSSs" + val + ".xpm");
	}
	pxSWI0->load(MainWidget::PATH + "pxSwitch0.xpm");
	pxSWI1->load(MainWidget::PATH + "pxSwitch1.xpm");
	PTOPL->load(MainWidget::PATH + "TopLarge.xpm");
	PMIDL->load(MainWidget::PATH + "MidLarge.xpm");
	PBOTL->load(MainWidget::PATH + "BotLarge.xpm");
	PTOP->load(MainWidget::PATH + "Top.xpm");
	PMID->load(MainWidget::PATH + "Mid.xpm");
	PBOT->load(MainWidget::PATH + "Bot.xpm");
	syAND->load(MainWidget::PATH + "AND.xpm");
	syOR->load(MainWidget::PATH + "OR.xpm");
	syXOR->load(MainWidget::PATH + "XOR.xpm");
	syINV->load(MainWidget::PATH + "INV.xpm");
	syOSZ->load(MainWidget::PATH + "OSZ.xpm");
	syNET->load(MainWidget::PATH + "NET.xpm");
	sySS->load(MainWidget::PATH + "pxSSsoff.xpm");
	syMONOFLOP->load(MainWidget::PATH + "MONOFLOP.xpm");
	pix_loaded = 1;
}

/***************************************************/
/* methods of XDevice instance                     */
/***************************************************/
XDevice::XDevice(int func, int x, int y)
	:Device(func, -1, -1, -1)
{
	_size = STATdef_size;
	inverted = STATdef_inverted;
	editable = 1;
	_maxi = MAXI;
	_maxo = MAXO;
	graph_enabled = 1;
	text_dev = (XDevice *)NULL;

	setFuncDep(func);
	setImage();
	initPos(x,y);
	setEquation();
	parseEquation();
	if (STATdisplay_name && func != fTXT) displayText(1);
}

XDevice::XDevice(int func, int x, int y, int size, int del, int undef, int clock)
	:Device(func, del, undef, clock)
{
	if ((size >= MINSIZE) && (size <= MAXSIZE)) _size = size;
	else _size = STATdef_size;
	inverted = STATdef_inverted;
	editable = 1;
	_maxi = MAXI;
	_maxo = MAXO;
	graph_enabled = 1;
	text_dev = (XDevice *)NULL;

	setFuncDep(func);
	setImage();
	initPos(x,y);
	setEquation();
	parseEquation();
	if (STATdisplay_name && func != fTXT) displayText(1);
}

// remove device: remove all inputs and outputs first
XDevice::~XDevice()
{
	// remove all inputs
	while (in_w.First())
		in_w.First()->Get()->disconnectInput(this);
	in_w.Destroy();

	// remove all outputs
	while (out_w.First())
		out_w.First()->Get()->disconnectOutput();
	out_w.Destroy();

	if (text_dev) delete text_dev;
}

int XDevice::contains(QPoint pt)
{
	// take attention about input and output area of a device
	if (!_maxo && !_maxi)
		return XObject::contains(pt, 0, 0);
	else if (!_maxi && _maxo)
		return XObject::contains(pt, 0, IOREG);
	else if (_maxi && !_maxo)
		 return XObject::contains(pt, IOREG, 0);
	else
		 return XObject::contains(pt, IOREG, IOREG);
}

int XDevice::contains(QRect r)
{
	return XObject::contains(r);
}

int XDevice::size()
{	return _size;
}

int XDevice::setSize(int new_s)
{	list<XWire> *lw;
	XWire *w;
	int min_size = MINSIZE;
	int maxy = 0;
	int idx;
	int retval;

	lw = in_w.First();
	while(lw) {
		w = lw->Get();
		idx = w->getConnectionIndex(this);
		if (w->getInputPosition(idx).y() - getPos().y() > maxy)
			maxy = w->getInputPosition(idx).y() - getPos().y();
		lw = lw->Next();
	}
	lw = out_w.First();
	while(lw) {
		w = lw->Get();
		if (w->getOutputPosition().y() - getPos().y() > maxy)
			maxy = w->getOutputPosition().y() - getPos().y();
		lw = lw->Next();
	}
	maxy = maxy / GRID;
	if (maxy > min_size) min_size = maxy;

	if (new_s > min_size) {
		if (_size != new_s) retval = 1;
		else retval = 0;
		_size = new_s;
	}
	else {
		if (_size != min_size) retval = 1;
		else retval = 0;
		_size = min_size;
	}
	return retval;
}

int XDevice::neededSize()
{	int new_size = MINSIZE;

	list<opStack> *lop = named_output.First();
	while(lop) {
		if ((lop->Get()->getPosition() + 1) > new_size)
			new_size = lop->Get()->getPosition();
		lop = lop->Next();
	}
	list<value> *lv = named_input.First();
	while(lv) {
		if (lv->Get()->getPosition() + 1 > new_size)
			new_size = lv->Get()->getPosition();
		lv = lv->Next();
	}

	if (new_size < MINSIZE) new_size = MINSIZE;
	return new_size;
}

int XDevice::maxI()
{	return _maxi;
}

int XDevice::currI()
{       return in_w.counter();
}

void XDevice::setMaxI(int newmax)
{	if (newmax < currI()) _maxi = currI();
	else _maxi = newmax;
}

int XDevice::maxO()
{	return _maxo;
}

int XDevice::currO()
{       return out_w.counter();
}

void XDevice::setMaxO(int newmax)
{	if (newmax < currO()) _maxo = currO();
	else _maxo = newmax;
}

// flag for the device-properties-dialog
int XDevice::isEditable()
{	return editable;
}

// output inverted by default?
int XDevice::isInverted()
{	return inverted;
}

// output inverted by default?
// 1=invert always
void XDevice::setInverted(int newi)
{	if (newi >= 1) inverted = 1;
	else inverted = 0;
}

void XDevice::setText(QString new_text)
{
	Device::setText((char *)(const char *)new_text);
	if (text_dev) {
		text_dev->setText(new_text);
		text_dev->setImage();
		text_dev->setVOffset(-3);
		text_dev->setHOffset(-IOREG);
		QRect dpos = getPos();
		QRect tpos = text_dev->getPos();
		QPoint _newpos;
		_newpos.setX(dpos.x() + dpos.width() / 2 - tpos.width() / 2);
		_newpos.setY(dpos.y() - tpos.height());
		text_dev->setPos(_newpos);
	}
	setImage();
}

// show/hide the name of the display
void XDevice::displayText(int flag)
{
	if (type() == fTXT) return;
	if (!getID()) return;
	if (flag) {
		if (text_dev) return;
		text_dev = new XDevice(fTXT, 0, 0);
		text_dev->setText(getText());
		text_dev->setImage();
		QRect dpos = getPos();
		QRect tpos = text_dev->getPos();
		QPoint _newpos;
		_newpos.setX(dpos.x() + dpos.width() / 2 - tpos.width() / 2);
		_newpos.setY(dpos.y() - tpos.height());
		text_dev->setVOffset(-3);
		text_dev->setHOffset(-IOREG);
		text_dev->setPos(_newpos);
	} else {
		if (!text_dev) return;
		delete text_dev;
		text_dev = (XDevice *)NULL;
	}
}

// is the name of the device shown/hidden
int XDevice::textDisplayed()
{
	if (text_dev) return 1;
	return 0;
}

// check if all outputs are inverted
int XDevice::invertGraph(int value, int output_id)
{	list<XWire> *l = out_w.First();

	if (!output_id) {
		while (l) {
			if (!l->Get()->outputIsInverted()) return value;
			l = l->Next();
		}
		if (value == 0) return 1;
		else return 0;
	} else {
		while (l) {
			if (l->Get()->outputID() == output_id) {
				if (!l->Get()->outputIsInverted()) return value;
				if (value == 0) return 1;
				else return 0;
			}
			l = l->Next();
		}
		// not found??
		return value;
	}
}

void XDevice::setClock(int new_clk)
{
	if (new_clk == clock()) return;

	if (clock() == CLK_NONE  && new_clk != CLK_NONE && type() == XDevice::fRS) {
		// remove all named inputs...
		while(named_input.First())
			removeInputName(named_input.First()->getID1());
		// ... and add the new ones
		addInputName("1S", 0);
		addInputName("C1", 2);
		addInputName("1R", 4);
	}
	if (clock() != CLK_NONE && new_clk == CLK_NONE && type() == XDevice::fRS) {
		// remove all named inputs...
		while(named_input.First())
			removeInputName(named_input.First()->getID1());
		// ... and add the new ones
		addInputName("S", 0);
		addInputName("R", 3);
	}
	if (type() == XDevice::fOSZ) {
		if (new_clk == CLK_MULTI) _maxi = 0;
		else _maxi = 1;
	}
	Device::setClock(new_clk);
	setImage();
}

// draw a graph in the simulation graph widget?
int XDevice::drawGraph()
{
	if ((type() != XDevice::fPWR) && (maxO()))
		return 1;
	return 0;
}

// returns if device should be shown in the simulation graph
int XDevice::graphEnabled()
{
	return graph_enabled;
}

// show device in the simulation graph
void XDevice::enableGraph(int i)
{
	if (i) graph_enabled = 1;
	else graph_enabled = 0;
}

// update positions of device-connections
void XDevice::erase(QPainter *p)
{	list<XWire> *l;

	if (text_dev) text_dev->erase(p);

	updateWires();
	l = in_w.First();
	while(l) {
		l->Get()->erase(p);
		l = l->Next();
	}
	l = out_w.First();
	while(l) {
		l->Get()->erase(p);
		l = l->Next();
	}
	XObject::erase(p);
}

// garbage collection for connected wires
void XDevice::garbageCollection()
{	list<XWire> *lw;

	lw = in_w.First();
	while(lw) {
		lw->Get()->Wire::garbageCollection();
		lw = lw->Next();
	}
	lw = out_w.First();
	while(lw) {
		lw->Get()->Wire::garbageCollection();
		lw = lw->Next();
	}
} 

// update nodes of wires which are connected to the device
void XDevice::updateWires()
{	QRect p1, p2;
	int dx, dy;
	list<XWire> *lw;
	XWire *w;
	QPoint newpos;
	int idx;

	p1 = getPos();
	p2 = getOldPos();
	dx = p1.x() - p2.x();
	dy = p1.y() - p2.y();
	newpos.setX(dx);
	newpos.setY(dy);
	lw = in_w.First();
	while(lw) {
		w = lw->Get();
		idx = w->getConnectionIndex(this);
		w->setInputPosition(w->getInputPosition(idx) + newpos, idx);
		lw = lw->Next();
	}
	lw = out_w.First();
	while(lw) {
		lw->Get()->setOutputPosition(lw->Get()->getOutputPosition() + newpos);
		lw = lw->Next();
	}
}

// checks, if actice-node of wire is input or output
// connects if given, or disconnects if not given
// wire must be locked!
int XDevice::checkConnection(XWire *w, int invert = 0)
{	int found;
	int ret1, ret2;

	// active node of w must be the first or last node of w
	if (!w->activeIsEnd()) return DOK;

	// set input-, device- and output-region
	setRegions();

	// check, if wire is already input
	if (in_w.Get(w)) found = 1;
	else found = 0;
	// new connected, connection lost or not connected?
	ret1 = checkInput(w, found, invert);
	if (ret1 != DOK && ret1 != DDISC) return ret1;

	// check, if wire is already output
	if (out_w.Get(w)) found = 1;
	else found = 0;
	// new connected, connection lost or not connected?
	ret2 = checkOutput(w, found, invert);
	if (ret2 != DOK && ret2 != DDISC) return ret2;

	if (ret1 == DDISC || ret2 == DDISC) return DDISC;
	return DOK;
}

int XDevice::checkInput(XWire *w, int found, int invert)
{	QPoint p = w->getActive();
	QPoint ap;
	int idx;
	int isconn = 0;
	list<value> *li = named_input.First();
	int new_id = 0;
	int conn_id = 0;

	if (!found) {
		// check input connection
		if (!input_region.contains(p)) return DOK;

		// connections in all points allowed
		if (!hasNamedInput()) {
			return connectInput(w, p, invert);
		}
		// connections only in some points allowed (named inputs)
		else {
			while (li) {
				new_id = li->getID1();
				ap.setX(getPos().x());
				ap.setY(li->Get()->getPosition() * GRID + getPos().y() + getVOffset());
				if (ap == p) return connectInput(w, p, invert, new_id);
				li = li->Next();
			}
		}
	} else {
		// check input disconnection
		idx = w->getConnectionIndex(this);
		p = w->getInputPosition(idx);

		if (!hasNamedInput()) {
			if (!input_region.contains(p)) {
				w->disconnectInput(this);
				return DDISC;
			}
		}
		else {
			while (li && !isconn) {
				new_id = li->getID1();
				ap.setX(getPos().x());
				ap.setY(li->Get()->getPosition() * GRID + getPos().y() + getVOffset());
				if (ap == p) isconn = 1;
				li = li->Next();
			}
			if (!isconn) {
				w->disconnectInput(this);
				return DDISC;
			} else {
				conn_id = w->getConnectionID(this);
				if (conn_id != new_id) {
					w->disconnectInput(this);
					connectInput(w, p, invert, new_id);
				}
			}
		}
	}
	return DOK;
}

// give wire the information to be an input to this device
// input-id: id of the named input of this device
int XDevice::connectInput(XWire *w, QPoint p, int invert, int input_id = 0)
{
	if (w->activeIsInput()) return DOK;

	// check that another input is allowed
	if (maxI() <= currI())
		return DFAILMAXI;

	if (WFAIL == w->connectInput(this, invert, input_id)) return DFAIL;

	// set the position of the input-node of the wire exactly to the connection-point of this device
	p.setX(getPos().x());
	w->setInputPosition(p);

	return DCONN;
}

int XDevice::checkOutput(XWire *w, int found, int invert)
{	QPoint p = w->getActive();
	QPoint ap;
	QRect r = getPos();
	int isconn = 0;
	int new_id = 0;
	int conn_id = 0;

	if (!found) {
		// check output connection
		if (!output_region.contains(p)) return DOK;

		if (!hasNamedOutput()) {
			if (w->activeIsOutput()) return DOK;
			// if the wire is not connected already, connect it now
			return connectOutput(w, p, invert);
		}
		// connections in some points allowed only
		else {
			list<opStack> *lo = named_output.First()->Next();
			while (lo) {
				if (!lo->Get()->isInternal()) {
					new_id = lo->getID1();
					ap.setX(r.x() + r.width() - 1);
					ap.setY(lo->Get()->getPosition() * GRID + r.y() + getVOffset());
					if (ap == p) return connectOutput(w, p, invert, new_id);
				}
				lo = lo->Next();
			}
		}
	}
	// check output disconnection
	// if wire is connected, disconnect it now
	else {
		p = w->getOutputPosition();
		if (!hasNamedOutput()) {
			if (!output_region.contains(p)) {
				w->disconnectOutput();
				return DDISC;
			}
		}
		else {
			list<opStack> *lo = named_output.First()->Next();
			while (lo && !isconn) {
				if (!lo->Get()->isInternal()) {
					new_id = lo->getID1();
					ap.setX(r.x() + r.width() - 1);
					ap.setY(lo->Get()->getPosition() * GRID + r.y() + getVOffset());
					if (ap == p) isconn = 1;
				}
				lo = lo->Next();
			}
			if (!isconn) {
				w->disconnectOutput();
				return DDISC;
			} else {
				conn_id = w->getConnectionID(this);
				if (conn_id != new_id) {
					w->disconnectOutput();
					return connectOutput(w, p, invert, new_id); 
				}
			}
		}
	}
	return DOK;
}

// give wire the information to get input from this (output-)device
// output-id: id of the named output of this device
int XDevice::connectOutput(XWire *w, QPoint p, int invert, int output_id = 0)
{
	// check that another output is allowed
	if (maxO() <= currO())
		return DFAILMAXO;

	if (DFAIL == w->connectOutput(this, invert, output_id)) return DFAIL;

	p.setX(getPos().x() + getPos().width() - 1);
	w->setOutputPosition(p);

	return DCONN;
}

void XDevice::setInputLine(XWire *w, QColor color, int no, QPainter *prt = (QPainter *)NULL, int x = 0, int y = 0)
{	QPixmap *pic = getImage();
	QPoint p1, p2;
	QRect r;
	QPainter *p;

	if (!prt) {
		p = new QPainter();
		p->begin(pic);
	} else p = prt;

	p1 = w->getInputPosition(no);
	r = getPos();

	if (p1.isNull()) return;

	p1.setX(x);
	p1.setY(y + p1.y() - r.y());
	p2.setX(x + IOREG);
	p2.setY(p1.y());

	p->setPen(color);
	if (w->inputIsInverted(this)) {
		p->setBrush(color);
		p->drawPie(p1.x(), p1.y() - 3, 5, 6, 0, 5760);
	} else {
		p->drawLine(p1, p2);
	}

	// inverter-pie lies 1 pixel in the base image
	if (type() != fPWR) {
		p->setPen(Qt::black);
		p->drawLine(p2.x(), p1.y() - 2, p2.x(), p1.y() +2);
	}

	if (!prt) {
		p->end();
		delete p;
	}
}

// called by XWire
// add wire to input-wire-list
// draw wire-connection into image of device
void XDevice::addInput(XWire *w, int no)
{
	setInputLine(w, Qt::black, no);
	in_w.Append(w);
}

// called by XWire
// remove wire from input-wire-list
void XDevice::removeInput(XWire *w, int no)
{
	setInputLine(w, Qt::white, no);
	in_w.Destroy(w);
}

void XDevice::setOutputLine(XWire *w, QColor color, QPainter *prt = (QPainter *)NULL, int x = 0, int y = 0)
{	QPixmap *pic = getImage();
	QPixmap pfkt;
	QPoint p1, p2;
	QRect r;
	QPainter *p;

	if (!prt) {
		p = new QPainter();
		p->begin(pic);
	} else p = prt;

	p1 = w->getOutputPosition();
	r = getPos();

	p1.setX(x + r.width() - IOREG - 1);
	p1.setY(y + p1.y() - r.y());
	p2 = p1;
	p2.setX(x + r.width());

	p->setPen(color);
	if (w->outputIsInverted()) {
		p->setBrush(color);
		p->drawPie(p1.x(), p1.y() - 3, 5, 6, 0, 5760);
		p->setBrush(Qt::white);
	}
	else {
		p->drawLine(p1, p2);
	}

	// inverter-pie lies 1 pixel in the base image
	if (type() != fPWR) {
		p->setPen(Qt::black);
		p->drawLine(p1.x(), p1.y() - 2, p1.x(), p1.y() +2);
	}

	if (!prt) {
		p->end();
		delete p;
	}
}

// called by XWire
// add wire to output-wire-list
void XDevice::addOutput(XWire *w)
{
	setOutputLine(w, Qt::black);
	out_w.Append(w);
}

// called by XWire
// remove wire from output-wire-list
void XDevice::removeOutput(XWire *w)
{
	setOutputLine(w, Qt::white);
	out_w.Destroy(w);
}

// called by device-net(-device)
// add an possible named input (no connection!)
int XDevice::addInputName(QString nam, int pos = -1, int input_id = 0)
{	int y = pos;
	int maxy = _size;
	int found;
	list<value> *li;
	int ret;

	if (pos >= 0) {
		// look if given entry is free
		found = 0;
		li = named_input.First();
		while (li) {
			if (!li->Get()->isInternal() && li->Get()->getPosition() == y)
				found = 1;
			li = li->Next();
		}
	} else {
		// search for a free entry
		do {
			found = 0;
			y ++;
			li = named_input.First();
			while (li) {
				if (!li->Get()->isInternal() && li->Get()->getPosition() == y)
					found = 1;
				li = li->Next();
			}
		} while (found && (y < maxy));
	}
	if (found) return ADDNAMED_FULL;

	// add input
	if (0 >= (ret = Device::addInputName(nam, y, input_id))) return ret;
	setImage();
	return ret;
}

// change an input name
// if the input does not exist, create a new named input
int XDevice::changeInputName(int input_id, QString nam)
{
	if (!input_id || !named_input.With(input_id)) {
		input_id = addInputName(nam);
	} else {
		Device::changeInputName(input_id, nam);
	}
	setImage();
	return input_id;
}

// remove a named input
void XDevice::removeInputName(int input_id)
{	list<XWire> *l = in_w.First();

	// remove all connections to this input
	while(l) {
		if (l->Get()->isNamedInput(this, input_id))
			l->Get()->disconnectInput(this);
		l = l->Next();
	}

	// remove input name
	Device::removeInputName(input_id);
	setImage();
}

// called by device-net(-device) and equation-device properties
// add an possible named output (no connection!)
int XDevice::addOutputName(QString nam, int pos = -1, int dev_id = 0)
{	int y = pos;
	int maxy = _size;
	int found = 1;
	list<opStack> *lo;

	// ignore ...
	if (!nam.length() || !nam.compare("(null)")) return ADDNAMED_OK;

	// search for a free entry
	if (pos >= 0) {
		// look if given entry is still free
		found = 0;
		lo = named_output.First();
		while (lo && !found) {
			if (!lo->Get()->isInternal() && lo->Get()->getPosition() == y)
				found = 1;
			lo = lo->Next();
		}
	} else {
		// try to find an empty entry
		do {
			found = 0;
			y ++;
			lo = named_output.First();
			while (lo) {
				if (!lo->Get()->isInternal() && lo->Get()->getPosition() == y)
					found = 1;
				lo = lo->Next();
			}
		} while (found && (y < maxy));
	}
	if (found) return ADDNAMED_FULL;

	// add output
	int ret;
	if (0 >= (ret = Device::addOutputName(nam, y, dev_id))) return ret;
	setImage();
	return ret;
}

int XDevice::changeOutputName(int output_id, QString nam)
{
	if (!output_id || !named_output.With(output_id)) {
		output_id = addOutputName(nam);
	} else {
		Device::changeOutputName(output_id, nam);
	}
	setImage();
	return output_id;
}

// called by device-net(-device) and equation-devices properties
// remove output name
void XDevice::removeOutputName(int output_id)
{	list<XWire> *lw = out_w.First();

	// remove all connections to this output
	while(lw) {
		if (lw->Get()->isNamedOutput(this, output_id))
			lw->Get()->disconnectOutput();
		lw = lw->Next();
	}

	// remove output name
	Device::removeOutputName(output_id);
	setImage();
}

list<XWire> * XDevice::getIRef()
{
	return &in_w;
}

list<XWire> * XDevice::getORef()
{
	return &out_w;
}

// create the device image
void XDevice::setImage()
{	QPixmap *pic = getImage();
	QPixmap *part = (QPixmap *)NULL;
	QPainter p;
	QPoint pt(0,0);
	QPoint pp(15,35);
	QRect _rect;
	list<opStack> *lop;
	list<value> *lv;
	int i;
	int pos;

	if (type() == fINV_INTERNAL) return;

	// first resize the device pixmap, assign the base image to "part"..
	switch (this->type()) {
		case fTXT:
			p.begin(pic);
			p.setFont( QFont( "helvetica", 10, QFont::Bold ) );
			_rect = p.boundingRect(1000, 1000, 1000, 1000, Qt::AlignLeft, getText());
			p.end();
			pic->resize(_rect.width() + 4, _rect.height());
			break;
		case fPWR:
			if (output()) part = pxPOS;
			else part = pxNEG;
			pic->resize(part->width(), part->height());
			break;
		case fRS:
			if (!hasMaster()) {
				if (clock() == CLK_NONE) part = pxRS;
				else part = pxRSC;
			} else {
				if (clock() == CLK_RISING_EDGE || clock() == CLK_FALLING_EDGE) part = pxRSCMF;
				else part = pxRSCM;
			}
			pic->resize(part->width(), part->height());
			break;
		case fDFF:
			if (hasMaster()) part = pxDM;
			else part = pxD;
			pic->resize(part->width(), part->height());
			break;
		case fJK:
			if (clock() == CLK_RISING_EDGE || clock() == CLK_FALLING_EDGE) part = pxJKF;
			else part = pxJK;
			pic->resize(part->width(), part->height());
			break;
		case fSWI:
			pic->resize(pxSWI0->width(), pxSWI0->height());
			break;
		case fSS:
			pic->resize(pxSSB->width(), pxSSB->height());
			break;
		case fLEDred:
			pic->resize(pxLED0red->width(), pxLED0red->height());
			break;
		case fLEDblue:
			pic->resize(pxLED0blue->width(), pxLED0blue->height());
			break;
		case fLEDgreen:
			pic->resize(pxLED0green->width(), pxLED0green->height());
			break;
		case fLEDyellow:
			pic->resize(pxLED0yellow->width(), pxLED0yellow->height());
			break;
		case fIN:
			pic->resize(pxIN->width(), pxIN->height());
			break;
		case fOUT:
			pic->resize(pxOUT->width(), pxOUT->height());
			break;
		case fEQU:
		case fNET:
			i =  PTOPL->height() + (PMIDL->height() * _size) + PBOTL->height();
			pic->resize(PTOPL->width(), i);
			break;
		default:
			i =  PTOP->height() + (PMID->height() * _size) + PBOT->height();
			pic->resize(PTOP->width(), i);
			break;
	}

	p.begin(pic);

	// ..then draw device the image
	switch (this->type()) {
		case fTXT:
			p.setBrush(Qt::white);
			p.setPen(Qt::black);
			p.drawRect(pic->rect());
			p.setFont( QFont( "helvetica", 10, QFont::Bold ) );
			p.drawText(3, pic->height() - 2, getText());
			setVOffset(-3);
			break;
		case fPWR:
			if (!part) fatal("no pixmap??");
			p.drawPixmap(pt, *part);
			setVOffset(5);
			break;
		case fRS:
			if (!part) fatal("no pixmap??");
			p.drawPixmap(pt, *part);
			switch (clock()) {
				case CLK_FALLING_EDGE:
				case CLK_LOW_VALUE:
					p.drawLine(pic->width() - 15, 3, pic->width() - 9, 3);
					p.drawLine(pic->width() - 9, 3, pic->width() - 9, 7);
					break;
				case CLK_RISING_EDGE:
				case CLK_HIGH_VALUE:
					p.drawLine(pic->width() - 15, 7, pic->width() - 9, 7);
					p.drawLine(pic->width() - 9, 3, pic->width() - 9, 7);
					break;
				default:
					break;
			}
			break;
		case fDFF:
			if (!part) fatal("no pixmap??");
			p.drawPixmap(pt, *part);
			break;
		case fJK:
			if (!part) fatal("no pixmap??");
			p.drawPixmap(pt, *part);
			p.drawLine(pic->width() - 9, 3, pic->width() - 9, 7);
			switch (clock()) {
				case CLK_FALLING_EDGE:
				case CLK_LOW_VALUE:
					p.drawLine(pic->width() - 15, 3, pic->width() - 9, 3);
					break;
				case CLK_RISING_EDGE:
				case CLK_HIGH_VALUE:
					p.drawLine(pic->width() - 15, 7, pic->width() - 9, 7);
					break;
				default:
					break;
			}
			break;
		case fSWI:
			p.drawPixmap(pt, *pxSWI0);
			break;
		case fSS:
			p.drawPixmap(pt, *pxSSB);
			pp.setX(pic->width()/2 - sySS->width()/2 + GRIDHALF - 3);
			pp.setY(pic->height()/2 - sySS->height()/2);
			p.drawPixmap(pp, *pxSS[0]);
			break;
		case fLEDred:
			p.drawPixmap(pt, *pxLED0red);
			break;
		case fLEDblue:
			p.drawPixmap(pt, *pxLED0blue);
			break;
		case fLEDgreen:
			p.drawPixmap(pt, *pxLED0green);
			break;
		case fLEDyellow:
			p.drawPixmap(pt, *pxLED0yellow);
			break;
		case fIN:
			p.drawPixmap(pt, *pxIN);
			// draw symbol
			p.setFont( QFont( "helvetica", 8, QFont::Bold ) );
			p.drawText(10, 9, getText());
			setVOffset(5);
			break;
		case fOUT:
			p.drawPixmap(pt, *pxOUT);
			// draw symbol
			p.setFont( QFont( "helvetica", 8, QFont::Bold ) );
			p.drawText(10, 9, getText());
			setVOffset(5);
			break;
		case fEQU:
		case fNET:
			// top of the device
			p.drawPixmap(pt, *PTOPL);
			pt.setY(pt.y() + PTOPL->height());

			// middle-part of device
			for(i=0;i<_size;i++) {
				p.drawPixmap(pt, *PMIDL);
				pt.setY(pt.y() + PMIDL->height());
			}

			// bottom of device
			p.drawPixmap(pt, *PBOTL);

			// draw input- and output names
			p.setFont( QFont( "helvetica", 8, QFont::Bold ) );
			lv = named_input.First();
			while(lv) {
				if (!lv->Get()->isInternal()) {
					pos = lv->Get()->getPosition() * GRID;
					if (lv->Get()->getPosition() == 0)
						p.drawText(IOREG + 4, pos + 7, lv->getText());
					else if (pos == (_size * GRID))
						p.drawText(IOREG + 4, pos + 5, lv->getText());
					else 
						p.drawText(IOREG + 4, pos + 6, lv->getText());
				}
				lv = lv->Next();
			}
			lop = named_output.First()->Next();
			while(lop) {
				if (!lop->Get()->isInternal()) {
					pos = lop->Get()->getPosition() * GRID;
					if (pos == 0)
						p.drawText(pic->width() / 2, pos - 2, 
						pic->width() / 2 - 3, 10, Qt::AlignRight, lop->getText());
					else if (pos == (_size * GRID))
						p.drawText(pic->width() / 2, pos - 4 ,
							pic->width() / 2 - 3, 10, Qt::AlignRight, lop->getText());
					else 
						p.drawText(pic->width() / 2, pos - 3,
							pic->width() / 2 - 3, 10, Qt::AlignRight, lop->getText());
				}
				lop = lop->Next();
			}

			break;
		default:
			// top of the device
			p.drawPixmap(pt, *PTOP);
			pt.setY(pt.y() + PTOP->height());

			// middle-part of device
			for(i=0;i<_size;i++) {
				p.drawPixmap(pt, *PMID);
				pt.setY(pt.y() + PMID->height());
			}

			// bottom of device
			p.drawPixmap(pt, *PBOT);

			// draw symbol
			switch(this->type()) {
				case fAND:
					pp.setX(pic->width()/2 - syAND->width()/2);
					pp.setY(pic->height()/2 - syAND->height()/2);
					p.drawPixmap(pp, *syAND);
					break;
				case fOR:
					pp.setX(pic->width()/2 - syOR->width()/2);
					pp.setY(pic->height()/2 - syOR->height()/2);
					p.drawPixmap(pp, *syOR);
					break;
				case fXOR:
					pp.setX(pic->width()/2 - syXOR->width()/2);
					pp.setY(pic->height()/2 - syXOR->height()/2);
					p.drawPixmap(pp, *syXOR);
					break;
				case fONE:
					pp.setX(pic->width()/2 - syINV->width()/2);
					pp.setY(pic->height()/2 - syINV->height()/2);
					p.drawPixmap(pp, *syINV);
					break;
				case fOSZ:
					if (clock() == CLK_MULTI) {
						pp.setX(pic->width()/2 - syOSZ->width()/2);
						pp.setY(pic->height()/2 - syOSZ->height()/2);
						p.drawPixmap(pp, *syOSZ);
					} else {
						pp.setX(pic->width()/2 - syMONOFLOP->width()/2);
						pp.setY(pic->height()/2 - syMONOFLOP->height()/2);
						p.drawPixmap(pp, *syMONOFLOP);
					}
					break;
				default:
					break;
			}

			break;
	}

	// draw connection lines of the new image
	drawConnectionLines(&p);

	// set image dimension, clear position
	XObject::setImage();

	p.end();

	if (text_dev) text_dev->setImage();
}

int XDevice::setPos(QPoint newpos)
{	int ret;

	ret = XObject::setPos(newpos);
	if (text_dev) {
		QRect dpos = getPos();
		QRect tpos = text_dev->getPos();
		QPoint _newpos;
		_newpos.setX(dpos.x() + dpos.width() / 2 - tpos.width() / 2);
		_newpos.setY(dpos.y() - tpos.height());
		text_dev->setPos(_newpos);
	}
	return ret;
}

// draw device to the screen
void XDevice::drawImage(QPaintDevice *paintd, QPainter *p)
{
	XObject::drawImage(paintd, p);
	if (text_dev) text_dev->drawImage(paintd, p);
}

// draw device as lines and text to a printer device
void XDevice::drawImage(QPainter *p)
{	QRect r;
	QPixmap *pic = getImage();
	int x,y;
	list<opStack> *lop;
	list<value> *lv;
	list<XWire> *l;
	int idx;
	int a,b,c,d,e, h;
	int pos;

	// position
	x = getPos().x();
	y = getPos().y();

	// draw connection lines
	l = in_w.First();
	while (l) {
		idx = l->Get()->getConnectionIndex(this);
		setInputLine(l->Get(), Qt::black, idx, p, x, y);
		l = l->Next();
	}
	l = out_w.First();
	while (l) {
		setOutputLine(l->Get(), Qt::black, p, x, y);
		l = l->Next();
	}

	x += IOREG;
	y -= getVOffset() / 2;

	// draw device rect
	r.setX(x);
	r.setY(y);
	r.setWidth(pic->width() - (IOREG * 2) - 1);
	r.setHeight(pic->height());
	p->setPen(Qt::black);
	if (type() != fPWR && type() != fSWI) {
		p->drawRect(r);
	}

	// draw io-names and type specific symbol
	switch(type()) {
		case fJK:
		case fRS:
		case fDFF:
		case fNET:
			p->setFont( QFont( "helvetica", 8, QFont::Bold ) );
			lv = named_input.First();
			while(lv) {
				pos = lv->Get()->getPosition() * GRID;
				if ((type() == fJK || type() == fDFF) &&
				    (strcmp(lv->getText(), "C1") == 0) && hasMaster()) {
					a = r.x();
					b = r.x() + 6;
					c = y + pos + 2;
					p->drawLine(a, c - 3, b, c);
					p->drawLine(a, c + 3, b, c);
					p->drawText(x + 6, y + pos + 5, lv->getText());
				} else {
					if (pos == 0)
						p->drawText(x + 1, y + pos + 7, lv->getText());
					else if (pos == (_size * GRID))
						p->drawText(x + 1, y + pos + 5, lv->getText());
					else
						p->drawText(x + 1, y + pos + 6, lv->getText());
				}
				lv = lv->Next();
			}
			if (type() == fJK || type() == fDFF || type() == fRS) {
				p->drawText(x + (pic->width() / 2), y - 2,
					pic->width() / 2 - 7, 10, Qt::AlignRight, "Q");
			} else {
				lop = named_output.First();
				while(lop) {
					pos = lop->Get()->getPosition() * GRID;
					if (pos == 0)
						p->drawText(x + (pic->width() / 2), y + pos - 2,
							pic->width() / 2 - 7, 10, Qt::AlignRight, lop->getText());
					else if (pos == (_size * GRID))
						p->drawText(x + (pic->width() / 2), y + pos - 4,
							pic->width() / 2 - 7, 10, Qt::AlignRight, lop->getText());
					else
						p->drawText(x + (pic->width() / 2), y + pos - 2,
							pic->width() / 2 - 7, 10, Qt::AlignRight, lop->getText());
					lop = lop->Next();
				}
			}
			break;
		case fIN:
			p->setFont( QFont( "helvetica", 8, QFont::Bold ) );
			p->drawText(x + 6, y + 9, getText());
			break;
		case fOUT:
			p->setFont( QFont( "helvetica", 8, QFont::Bold ) );
			p->drawText(x + 6, y + 9, getText());
			break;
		case fAND:
			p->setFont( QFont( "helvetica", 16, QFont::Bold ) );
			p->drawText(x + (pic->width() / 2) - 8, y + (pic->height() / 2) + 5, "&");
			break;
		case fOR:
			p->setFont( QFont( "helvetica", 16, QFont::Bold ) );
			p->drawText(x + (pic->width() / 2) - 8, y + (pic->height() / 2) + 1, ">");
			p->drawText(x + (pic->width() / 2) - 8, y + (pic->height() / 2) + 1, "_");
			break;
		case fXOR:
			p->setFont( QFont( "helvetica", 16, QFont::Bold ) );
			p->drawText(x + (pic->width() / 2) - 8, y + (pic->height() / 2) + 3, "=");
			break;
		case fONE:
			p->setFont( QFont( "helvetica", 16, QFont::Bold ) );
			p->drawText(x + (pic->width() / 2) - 8, y + (pic->height() / 2) + 5, "1");
			break;
		case fOSZ:
			if (clock() == CLK_MULTI) {
				a = r.x() + 2;
				h = (r.width() - IOREG) / IOREG;
				d = r.y() + (r.height() / 2) - 4;
				e = r.y() + (r.height() / 2) + 4;
				p->drawLine(a, e, a + h, e);
				p->drawLine(a + h, e, a + h, d);
				p->drawLine(a + h, d, a + h + h, d);
				p->drawLine(a + h + h, d, a + h + h, e);
				p->drawLine(a + h + h, e, a + h + h + h, e);
				p->drawLine(a + h + h + h, e, a + h + h + h, d);
				p->drawLine(a + h + h + h, d, a + h + h + h + h, d);
			} else {
				a = r.x() + 2;
				h = (r.width() - IOREG) / IOREG;
				d = r.y() + (r.height() / 2) - 4;
				e = r.y() + (r.height() / 2) + 4;
				p->drawLine(a, e, a + h, e);
				p->drawLine(a + h, e, a + h, d);
				p->drawLine(a + h, d, a + h + h, d);
				p->drawLine(a + h + h, d, a + h + h, e);
				p->drawLine(a + h + h, e, a + h + h + h + h, e);
			}
			break;
		case fSWI:
			r.setY(y + 12);
			r.setHeight(pic->height() - 20);
			p->drawRect(r);
			a = r.x() + 8;
			b = r.x() + r.width() - 7;
			c = r.y() + (r.height() / 2) + 1;
			p->drawLine(r.x() + 2, c, a, c);
			p->drawLine(b, c, r.x() + r.width() - 2, c);
			p->drawLine(a, c, b + 1, c - 3);
			p->drawLine(b, c, b, c - 4);
			break;
		case fSS:
		case fLEDred:
		case fLEDblue:
		case fLEDgreen:
		case fLEDyellow:
			a = r.x() + IOREG;
			b = r.x() + r.width() - IOREG;
			c = r.y() + (r.height() / 2);
			d = c - 4;
			e = c + 4;
			p->drawLine(r.x() + 2, c, r.x() + r.width() - 2, c);	// -
			p->drawLine(a, d, a, e);				// |
			p->drawLine(b, d, b, e);				//   |
			p->drawLine(a, d, b, c);				//  backslash
			p->drawLine(a, e, b, c);				//  /
			a = a + 2;
			d = d - 1;
			p->drawLine(a, d, a + 2, d - 2);
			p->drawLine(a + 1, d - 2, a + 2, d - 2);
			p->drawLine(a + 2, d - 2, a + 2, d - 1);
			a = a + 2;
			p->drawLine(a, d, a + 2, d - 2);
			p->drawLine(a + 1, d - 2, a + 2, d - 2);
			p->drawLine(a + 2, d - 2, a + 2, d - 1);
			break;
		case fPWR:
			a = r.x() + 2;
			b = r.y() + (r.height() / 2) + 2;
			c = r.x() + r.width() - IOREG - 2;
			d = r.x() + ((r.width() - IOREG) / 2);
			p->drawArc(r.x(), r.y() + 3, r.width() - IOREG, r.height() - 3, 0, 5760);
			p->drawLine(a, b, c, b);
			if (output()) p->drawLine(d, r.y() + 5, d, r.y() + r.height() - 2);
			// extended connection line
			p->drawLine(r.x() + r.width() - IOREG, b, r.x() + r.width(), b);
			break;
		default:
			break;
	}
}

void XDevice::eraseConnectionLines(QPainter *prt = (QPainter *)NULL)
{	QPixmap *pic;
	QPainter *p;
	list<XWire> *l;
	int idx;

	if (!prt) {
		pic = getImage();
		p = new QPainter();
		p->begin(pic);
	} else p = prt;

	// draw input lines
	l = in_w.First();
	while (l) {
		idx = l->Get()->getConnectionIndex(this);
		setInputLine(l->Get(), Qt::white, idx, p);
		l = l->Next();
	}

	// draw output lines
	l = out_w.First();
	while (l) {
		setOutputLine(l->Get(), Qt::white, p);
		l = l->Next();
	}

	if (!prt) {
		p->end();
		delete p;
	}
}
void XDevice::drawConnectionLines(QPainter *prt = (QPainter *)NULL)
{	QPixmap *pic;
	QPainter *p;
	list<XWire> *l;
	int idx;

	if (!prt) {
		pic = getImage();
		p = new QPainter();
		p->begin(pic);
	} else p = prt;

	// draw input lines
	l = in_w.First();
	while (l) {
		idx = l->Get()->getConnectionIndex(this);
		setInputLine(l->Get(), Qt::black, idx, p);
		l = l->Next();
	}

	// draw output lines
	l = out_w.First();
	while (l) {
		setOutputLine(l->Get(), Qt::black, p);
		l = l->Next();
	}

	if (!prt) {
		p->end();
		delete p;
	}
}

void XDevice::setRegions()
{	QPixmap *pic = getImage();
	QRect p = getPos();

	input_region.setX(p.x() - 1);
	input_region.setY(p.y());
	input_region.setWidth(IOREG + 2);
	input_region.setHeight(pic->height());
	output_region.setX(p.x() + pic->width() - IOREG - 1);
	output_region.setY(p.y());
	output_region.setWidth(IOREG + 2);
	output_region.setHeight(pic->height());
}

void XDevice::setFuncDep(int function)
{
	switch (function) {
		case fONE:
			inverted = 1;
			_size = MINSIZE;
			_maxi = 1;
			break;
		case fPWR:
			inverted = 0;
			_maxi = 0;
			_maxo = 1;
			break;
		case fSS:
			inverted = 0;
			_maxi = 4;
			_maxo = 0;
			s7_1_id = addInputName("2^0", 0);
			s7_2_id = addInputName("2^1", 1);
			s7_4_id = addInputName("2^2", 2);
			s7_8_id = addInputName("2^3", 3);
			break;
		case fLEDred:
		case fLEDblue:
		case fLEDgreen:
		case fLEDyellow:
			inverted = 0;
			_maxi = 4;
			_maxo = 0;
			break;
		case fSWI:
			inverted = 0;
			_maxi = 0;
			editable = 0;
			break;
		case fIN:
			inverted = 0;
			_maxi = 0;
			editable = 0;
			break;
		case fOUT:
			inverted = 0;
			_maxo = 0;
			editable = 0;
			break;
		case fOSZ:
			inverted = 0;
			_size = MINSIZE;
			if (clock() == CLK_MULTI) _maxi = 0;
			else _maxi = 1;
			break;
		case fTXT:
			inverted = 0;
			_size = MINSIZE;
			_maxi = 0;
			_maxo = 0;
			break;
		case fRS:
			inverted = 0;
			addInputName("S", 0);
			addInputName("R", 3);
			mq_id = addInternalName("MQ");
			c1_1_id = addInternalName("C1-1");
			break;
		case fJK:
			inverted = 0;
			addInputName("1J", 0);
			addInputName("C1", 2);
			addInputName("1K", 4);
			mq_id = addInternalName("MQ");
			c1_1_id = addInternalName("C1-1");
			break;
		case fDFF:
			inverted = 0;
			addInputName("1D", 0);
			addInputName("C1", 3);
			mq_id = addInternalName("MQ");
			c1_1_id = addInternalName("C1-1");
			break;
		case fEQU:
			_size = MINSIZE;
			break;
	}
}

// calculation method:
// modifies image of a device in dependance of output
int XDevice::setColor()
{	QString path;
	QPixmap *pic = getImage();
	QPixmap *img;
	QPoint pp(15,35);
	QPainter p;
	QString value;
	list<XWire> *l;

	if (!this->outputChanged()) return 0;

	// determine current value-dependant image
	switch(this->type()) {
	case fLEDred:
	case fLEDblue:
	case fLEDgreen:
	case fLEDyellow:
		switch(this->type()) {
		case fLEDred:
			if (this->output()) img = pxLED1red;
			else img = pxLED0red;
			break;
		case fLEDblue:
			if (this->output()) img = pxLED1blue;
			else img = pxLED0blue;
			break;
		case fLEDgreen:
			if (this->output()) img = pxLED1green;
			else img = pxLED0green;
			break;
		case fLEDyellow:
			if (this->output()) img = pxLED1yellow;
			else img = pxLED0yellow;
			break;
		}
		p.begin(pic);
		pp.setX(0);
		pp.setY(0);
		p.drawPixmap(pp, *img);
		drawConnectionLines(&p);
		p.end();
		return 1;
		break;
	case fSS:
		img = pxSS[this->output()];
		p.begin(pic);
		pp.setX(pic->width()/2 - (img->width()/2) + GRIDHALF - 3);
		pp.setY(pic->height()/2 - img->height()/2);
		p.drawPixmap(pp, *img);
		p.end();
		return 1;
		break;
	case fSWI:
		if (this->output()) img = pxSWI1;
		else img = pxSWI0;
		p.begin(pic);
		pp.setX(0);
		pp.setY(0);
		p.drawPixmap(pp, *img);
		p.end();
		// draw output lines
		l = out_w.First();
		while (l) {
			setOutputLine(l->Get(), Qt::black);
			l = l->Next();
		}
		return 1;
		break;
	}
	return 0;
}

QString XDevice::device2string(int dx, int dy)
{	QString ret;
	QString buf;

	// add device parameters
	ret = "\t";
	ret += Device::device2string();

	// set mark to the beginning of xdevice parameters
	ret += DLM;
	ret += (char)2;

	// add xdevice parameters
	buf.sprintf("%c%d%c%d%c%d",
		DLM,
		size(), DLM,
		getPos().x() - dx, DLM,
		getPos().y() + getVOffset() - dy);
	ret += buf;

	list<opStack> *lo = named_output.First()->Next();	// the first output in the list is an universal unnamed output
	if (lo) {
		buf.sprintf("%c%c%d", DLM, 3, lo->counter() - 1);	//CRTL-C
		ret += buf;
	}

	if (type() == fEQU || type() == fNET) {
		// saving the device id's here ... the text comes with the device itself!
		while(lo) {
			if (type() != fEQU) buf.sprintf("%c%d%c%d%c%d%c", DLM, lo->getID1(), DLM, lo->Get()->getPosition(), DLM, lo->Get()->isInternal(), DLM);
			else buf.sprintf("%c%s%c%d%c%d%c", DLM, lo->getText(), DLM, lo->Get()->getPosition(), DLM, lo->Get()->isInternal(), DLM);
			ret += buf;
			if (getEquation(lo->getID1())) ret += getEquation(lo->getID1());
			lo = lo->Next();
		}
		list<value> *li = named_input.First();
		if (li) {
			buf.sprintf("%c%c%d", DLM, 4, li->counter());		//CRTL-D
			ret += buf;
		}
		while(li) {
			if (type() !=  fEQU) buf.sprintf("%c%d%c%d%c%d", DLM, li->getID1(), DLM, li->Get()->getPosition(), DLM, li->Get()->isInternal());
			else buf.sprintf("%c%s%c%d%c%d", DLM, li->getText(), DLM, li->Get()->getPosition(), DLM, li->Get()->isInternal());
			ret += buf;
			li = li->Next();
		}
	}

	buf.sprintf("%c%d", DLM, textDisplayed());
	ret += buf; 

	return ret;
}

// returns 0 on success
int XDevice::string2device(QString s, int dx, int dy)
{	int ret;
	QString xs;
	QString buf;
	int apos, epos, cnt, i;
	int pos;
	QPoint pt;
	char *equation;
	int internal;
	int redraw = 0;
	int finished = 0;
	QString dev_id_string;
	bool id_flag;
	int dev_id;

	ret = Device::string2device(s);
	if (ret != 0) return ret;

	cnt = s.length() - s.find((char)2);
	xs = s.right(cnt);

	epos = xs.find(DLM, 0);
	if (epos == -1) return -1;

	// size
	apos = epos + 1;
	epos = xs.find(DLM, apos);
	if (epos == -1) return -1;
	redraw = setSize(xs.mid(apos, epos - apos).toInt());

	// position
	apos = epos + 1;
	epos = xs.find(DLM, apos);
	if (epos == -1) return -1;
	pt.setX(xs.mid(apos, epos - apos).toInt() + dx);
	apos = epos + 1;
	epos = xs.find(DLM, apos);
	if (epos == -1) {
		finished = 1;
		epos = xs.length();
	}
	pt.setY(xs.mid(apos, epos - apos).toInt() + dy);
	initPos(pt.x(), pt.y());
	setPos(pt);

	// named output
	apos = epos + 1;
	if (!finished && -1 != (epos = xs.find((char)3, apos))) {
		apos = epos + 1;
		epos = xs.find(DLM, apos);
		if (epos == -1) return -1;
		cnt = xs.mid(apos, epos - apos).toInt();
		for(i=0; i < cnt; i++) {
			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) return -1;
			buf = xs.mid(apos, epos - apos);
			dev_id_string = buf;
			dev_id = dev_id_string.toInt(&id_flag);
			if (id_flag == FALSE) dev_id = 0;
			

			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) {
				return -1;
			}
			pos = xs.mid(apos, epos - apos).toInt();

			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) {
				return -1;
			}
			internal = xs.mid(apos, epos - apos).toInt();

			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) {
				finished = 1;
				epos = xs.length();
			}
			buf = xs.mid(apos, epos - apos);
			equation = (char *)(const char *)buf;

			if (!internal) dev_id = addOutputName(dev_id_string, pos, dev_id);
			else dev_id = addInternalName(dev_id_string);
			setEquation(equation, dev_id);
		}
	}

	// named input
	if (epos != -1) apos = epos + 1;
	if (!finished && -1 != (epos = xs.find((char)4, apos))) {
		apos = epos + 1;
		epos = xs.find(DLM, apos);
		if (epos == -1) return -1;
		cnt = xs.mid(apos, epos - apos).toInt();
		for(i=0; i < cnt; i++) {
			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) return -1;
			buf = xs.mid(apos, epos - apos);
			dev_id_string = buf;
			dev_id = dev_id_string.toInt(&id_flag);
			if (id_flag == FALSE) dev_id = 0;

			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) epos = xs.length();
			pos = xs.mid(apos, epos - apos).toInt();

			apos = epos + 1;
			epos = xs.find(DLM, apos);
			if (epos == -1) {
				finished = 1;
				epos = xs.length();
			}
			internal = xs.mid(apos, epos - apos).toInt();

			if (!internal) dev_id = addInputName(dev_id_string, pos, dev_id);
			else addInternalName(dev_id_string);
		}
	}

	if (!finished) {
		if (epos != -1) apos = epos + 1;
		epos = xs.find(DLM, apos);
		if (epos == -1) {
			finished = 1;
			epos = xs.length();
		}
		displayText(xs.mid(apos, epos - apos).toInt());
	}

	// change some inputs/outputs?
	if ((clock() < 4) && (type() == XDevice::fRS)) {
		// remove all named inputs...
		while(named_input.First())
			removeInputName(named_input.First()->getID1());
		// ... and add the new ones
		addInputName("1S", 0);
		addInputName("C1", 2);
		addInputName("1R", 4);
	}
	if (clock() == CLK_MONO && type() == XDevice::fOSZ) {
		_maxi = 1;
	}
	setText(getText());

	if (redraw ||
	    type() == fRS || type() == fJK ||
	    type() == fDFF || type() == fNET ||
	    type() == fEQU || type() == fSS || type() == fOSZ)
		setImage();

	parseEquation();

	setColor();

	return 0;
}

