#ifndef __XNet_CLASS__
#define __XNet_CLASS__

#include <qfile.h>
#include <qstring.h>
#include <qpoint.h>
#include <qpaintdevice.h>

#include "value.h"
#include "xdevice.h"
#include "xwire.h"
#include "selection.h"

#define EXP_ALL		0
#define EXP_SELECTION	1

#define NO_SELECTION	0
#define SELECT_IT	1

#define IF_INPUT	0
#define IF_OUTPUT	1

/*********************************************
* a network of devices with their connections
* is a device itself
*********************************************/
class XDeviceNet: public XDevice
{
public:
	XDeviceNet();
	XDeviceNet(XDeviceNet *, int, int);
	~XDeviceNet();

	//***** net operations
	XDevice *containsDev(QPoint);		// check all devices for containing the point, returns first
	XDevice *containsDev(XDevice *);	// check all devices for containing the device, returns first
	XWire *containsWire(QPoint);		// check all connections for containing the point, returns first

	int checkCircuitNames();		// check if all names within this circuit are unique
	int unifyCircuitNames();		// make all names within this circuit unique
	void deleteNet(QPainter *);		// delete content of the net
	XDeviceNet *devIsNet(XDevice *);	// get pointer of net from netdevice
	XDeviceNet *subNet(QString);		// get pointer of net by name
	XDeviceNet *rootParent();		// get pointer of root net
	XDeviceNet *parent();			// get pointer of parent net
	int calcDelay();			// calculate delay as the sum of delay of all devices in the net
	int netDelay();				// get delay of the whole net
	int empty();				// 1 if net contains nothing
	// get list of equations describing the content of the circuit
	list<OutputInfo> * parseCircuit(char *qualifier=(char *)NULL, list<OutputInfo> *ls = (list<OutputInfo> *)NULL);
	void applyDefaults();			// apply device defaults to all devices

	//***** select groups of objects contained in rect
	void selectDev(QRect, list<XDevice> *);
	void selectWire(QRect, list<XWire> *);
	void grabSelection(Selection *);

	//***** drawing methods
	void drawDev(QPaintDevice *, QPainter *, XDevice *);	// draw device and all wires of it
	void drawAll(QPaintDevice *, QPainter *);		// draw all devices and wires
	void drawStatus(QPaintDevice *, QPainter *);		// (simulation) draw actually changed devices and wires

	//***** device methods
	XDevice * newDevice(int func, int x, int y, int import=0);
	int setInput(char *Name, int anz, int imp[]);
	void deleteDevice(QPainter *, XDevice *);		// remove device properly
	void setText(int, QString);				// set new text for device with given id

	//***** connection methods
	int checkConnection(XWire *);				// check wire for connections
	int checkConnection(int, int, XWire *); 		// used as import-function!

	//***** wire methods
	XWire * newWire(QPainter *, QPoint);
	int removeNode(QPainter *, QPoint);
	int releaseWire(QPainter *, XWire *);			// final works for locked wire
	void deleteWire(XWire *);				// remove wire properly

	//***** calculation operations
	void flush();
	void Burst(int burst);

	//***** import/export methods
	QString exportInstance();
	QString exportDevices(int selonly, int dx=0, int dy=0);
	QString exportWires(int selonly, int dx=0, int dy=0);
	QString exportWireConn(int selonly, int dx=0, int dy=0);
	QString exportDevConn(int selonly, int dx=0, int dy=0);
	void initImport();
	int importInstance(QString, int dx=0, int dy=0);
	int importDevice(QString, int select, int dx=0, int dy=0);
	int importWire(QString, int select, int dx=0, int dy=0);
	int importWireConn(QString, int select, int dx=0, int dy=0);
	int importDevConn(QString, int select, int dx=0, int dy=0);

	list<XDeviceNet> * subnetPointer();
	list<XDevice> * devPointer();
private:
	//***** calculation operations
	void switchInterface(int);
	void Calculate(int);
	void Propagate(int);

	// list of all devices in the net
	list<XDevice> netdev;

	// list of all connections in the net
	list<XWire> netwire;

	// interface to the parent circuit
	list<XDevice> netin;
	list<XDevice> netout;

	// list of all sub-circuits in the net
	list<XDeviceNet> netnet;
	XDeviceNet *_parent;

	// sum of the delay of all devices
	int delay;

	int wireOK(QPainter *,XWire *);		// check wire for a minimum of 2 points

	// name mapping for import operation
	ImportMapper devmap;
	ImportMapper wiremap;

// ***********************
// to be removed..
public:
	int hist_importInstance(QString s);
	int hist_importDevice(QString s, int select, int dx = 0, int dy = 0);
	int hist_isHist(QString);
// .. to be removed
// ***********************
};

#endif

